/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.storage.repository;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.armeria.common.util.UnmodifiableFuture;
import com.linecorp.centraldogma.common.Author;
import com.linecorp.centraldogma.common.Change;
import com.linecorp.centraldogma.common.Entry;
import com.linecorp.centraldogma.common.EntryNotFoundException;
import com.linecorp.centraldogma.common.Markup;
import com.linecorp.centraldogma.common.Revision;
import com.linecorp.centraldogma.internal.CredentialUtil;
import com.linecorp.centraldogma.internal.Jackson;
import com.linecorp.centraldogma.internal.api.v1.MirrorRequest;
import com.linecorp.centraldogma.internal.shaded.cronutils.model.Cron;
import com.linecorp.centraldogma.internal.shaded.cronutils.model.field.CronField;
import com.linecorp.centraldogma.internal.shaded.cronutils.model.field.CronFieldName;
import com.linecorp.centraldogma.internal.shaded.guava.base.Preconditions;
import com.linecorp.centraldogma.internal.shaded.guava.base.Strings;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableMap;
import com.linecorp.centraldogma.server.ZoneConfig;
import com.linecorp.centraldogma.server.command.Command;
import com.linecorp.centraldogma.server.command.CommitResult;
import com.linecorp.centraldogma.server.credential.Credential;
import com.linecorp.centraldogma.server.internal.storage.repository.MirrorConfig;
import com.linecorp.centraldogma.server.internal.storage.repository.MirrorConverter;
import com.linecorp.centraldogma.server.internal.storage.repository.RepositoryMetadataException;
import com.linecorp.centraldogma.server.internal.storage.repository.RepositoryWrapper;
import com.linecorp.centraldogma.server.mirror.Mirror;
import com.linecorp.centraldogma.server.mirror.MirrorDirection;
import com.linecorp.centraldogma.server.storage.repository.FindOption;
import com.linecorp.centraldogma.server.storage.repository.MetaRepository;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.eclipse.jgit.lib.Repository;

public final class DefaultMetaRepository
extends RepositoryWrapper
implements MetaRepository {
    private static final Pattern MIRROR_PATH_PATTERN = Pattern.compile("/repos/[^/]+/mirrors/[^/]+\\.json");
    private static final Pattern REPO_CREDENTIAL_PATH_PATTERN = Pattern.compile("/repos/[^/]+/credentials/[^/]+\\.json");
    private static final Pattern PROJECT_CREDENTIAL_PATH_PATTERN = Pattern.compile("/credentials/[^/]+\\.json");
    public static final String CREDENTIALS = "/credentials/";
    public static final String LEGACY_MIRRORS_PATH = "/mirrors/";
    public static final String ALL_MIRRORS = "/repos/*/mirrors/*.json";

    public static boolean isMirrorOrCredentialFile(String path) {
        return MIRROR_PATH_PATTERN.matcher(path).matches() || REPO_CREDENTIAL_PATH_PATTERN.matcher(path).matches() || PROJECT_CREDENTIAL_PATH_PATTERN.matcher(path).matches();
    }

    public static String mirrorFile(String repoName, String mirrorId) {
        return "/repos/" + repoName + LEGACY_MIRRORS_PATH + mirrorId + ".json";
    }

    public DefaultMetaRepository(com.linecorp.centraldogma.server.storage.repository.Repository repo) {
        super(repo);
    }

    @Override
    public Repository jGitRepository() {
        return this.unwrap().jGitRepository();
    }

    @Override
    public CompletableFuture<List<Mirror>> mirrors(boolean includeDisabled) {
        CompletableFuture<List<Mirror>> future = this.allMirrors();
        return DefaultMetaRepository.maybeFilter(future, includeDisabled);
    }

    @Override
    public CompletableFuture<List<Mirror>> mirrors(String repoName, boolean includeDisabled) {
        CompletableFuture<List<Mirror>> future = this.allMirrors(repoName);
        return DefaultMetaRepository.maybeFilter(future, includeDisabled);
    }

    private static CompletableFuture<List<Mirror>> maybeFilter(CompletableFuture<List<Mirror>> future, boolean includeDisabled) {
        if (includeDisabled) {
            return future;
        }
        return future.thenApply(mirrors -> (List)mirrors.stream().filter(Mirror::enabled).collect(ImmutableList.toImmutableList()));
    }

    @Override
    public CompletableFuture<Mirror> mirror(String repoName, String id, Revision revision) {
        String mirrorFile = DefaultMetaRepository.mirrorFile(repoName, id);
        return this.find(revision, mirrorFile).thenCompose(entries -> {
            MirrorConfig c;
            Entry entry = (Entry)entries.get(mirrorFile);
            if (entry == null) {
                throw new EntryNotFoundException("failed to find mirror '" + mirrorFile + "' in " + this.parent().name() + "/" + this.name() + " (revision: " + String.valueOf(revision) + ")");
            }
            JsonNode mirrorJson = (JsonNode)entry.content();
            if (!mirrorJson.isObject()) {
                throw this.newInvalidJsonTypeException(mirrorFile, mirrorJson);
            }
            try {
                c = (MirrorConfig)Jackson.treeToValue((TreeNode)mirrorJson, MirrorConfig.class);
            }
            catch (JsonProcessingException e) {
                throw new RepositoryMetadataException("failed to load the mirror configuration", e);
            }
            if (c.credentialName().isEmpty()) {
                if (!this.parent().repos().exists(repoName)) {
                    throw this.mirrorNotFound(revision, mirrorFile);
                }
                return CompletableFuture.completedFuture(MirrorConverter.convertToMirror(c, this.parent(), Credential.NONE));
            }
            CompletableFuture<Credential> future = this.credential(c.credentialName());
            return future.thenApply(credential -> MirrorConverter.convertToMirror(c, this.parent(), credential));
        });
    }

    private EntryNotFoundException mirrorNotFound(Revision revision, String mirrorFile) {
        return new EntryNotFoundException("failed to find a mirror config for '" + mirrorFile + "' in " + this.parent().name() + "/" + this.name() + " (revision: " + String.valueOf(revision) + ")");
    }

    private CompletableFuture<List<Mirror>> allMirrors() {
        return this.find(ALL_MIRRORS).thenCompose(this::handleAllMirrors);
    }

    private CompletableFuture<List<Mirror>> allMirrors(String repoName) {
        return this.find("/repos/" + repoName + "/mirrors/*.json").thenCompose(this::handleAllMirrors);
    }

    private CompletableFuture<List<Mirror>> handleAllMirrors(Map<String, Entry<?>> entries) {
        if (entries.isEmpty()) {
            return UnmodifiableFuture.completedFuture((Object)ImmutableList.of());
        }
        CompletableFuture<List<Credential>> future = this.allCredentials();
        return future.thenApply(credentials -> {
            List<MirrorConfig> mirrorConfigs = this.toMirrorConfigs(entries);
            return (List)mirrorConfigs.stream().map(mirrorConfig -> MirrorConverter.convertToMirror(mirrorConfig, this.parent(), credentials)).filter(Objects::nonNull).collect(ImmutableList.toImmutableList());
        });
    }

    private CompletableFuture<List<Credential>> allCredentials() {
        return this.find("/credentials/*.json,/repos/*/credentials/*.json").thenApply(entries -> this.credentials((Map<String, Entry<?>>)entries, null));
    }

    private List<MirrorConfig> toMirrorConfigs(Map<String, Entry<?>> entries) {
        return (List)entries.entrySet().stream().map(entry -> {
            JsonNode mirrorJson = (JsonNode)((Entry)entry.getValue()).content();
            if (!mirrorJson.isObject()) {
                throw this.newInvalidJsonTypeException((String)entry.getKey(), mirrorJson);
            }
            try {
                return (MirrorConfig)Jackson.treeToValue((TreeNode)mirrorJson, MirrorConfig.class);
            }
            catch (JsonProcessingException e) {
                return (MirrorConfig)Exceptions.throwUnsafely((Throwable)e);
            }
        }).collect(ImmutableList.toImmutableList());
    }

    @Override
    public CompletableFuture<List<Credential>> projectCredentials() {
        return this.find("/credentials/*.json").thenApply(entries -> this.credentials((Map<String, Entry<?>>)entries, null));
    }

    @Override
    public CompletableFuture<List<Credential>> repoCredentials(String repoName) {
        return this.find("/repos/" + repoName + "/credentials/*.json").thenApply(entries -> this.credentials((Map<String, Entry<?>>)entries, repoName));
    }

    private List<Credential> credentials(Map<String, Entry<?>> entries, @Nullable String repoName) {
        if (entries.isEmpty()) {
            return ImmutableList.of();
        }
        try {
            return this.parseCredentials(entries);
        }
        catch (Exception e) {
            Object message = "failed to load the credential configuration";
            if (repoName != null) {
                message = (String)message + " for " + repoName;
            }
            throw new RepositoryMetadataException((String)message, e);
        }
    }

    @Override
    public CompletableFuture<Credential> credential(String credentialName) {
        String credentialFile = CredentialUtil.credentialFile((String)credentialName);
        return this.credential0(credentialFile);
    }

    private CompletableFuture<Credential> credential0(String credentialFile) {
        return this.find(credentialFile).thenApply(entries -> {
            Entry entry = (Entry)entries.get(credentialFile);
            if (entry == null) {
                throw new EntryNotFoundException("failed to find credential file '" + credentialFile + "' in " + this.parent().name() + "/" + this.name());
            }
            try {
                return this.parseCredential(credentialFile, (Entry<JsonNode>)entry);
            }
            catch (Exception e) {
                throw new RepositoryMetadataException("failed to load the credential configuration. credential file: " + credentialFile, e);
            }
        });
    }

    private List<Credential> parseCredentials(Map<String, Entry<?>> entries) throws JsonProcessingException {
        return (List)entries.entrySet().stream().map(entry -> {
            try {
                return this.parseCredential((String)entry.getKey(), (Entry<JsonNode>)((Entry)entry.getValue()));
            }
            catch (JsonProcessingException e) {
                return (Credential)Exceptions.throwUnsafely((Throwable)e);
            }
        }).collect(ImmutableList.toImmutableList());
    }

    private Credential parseCredential(String credentialFile, Entry<JsonNode> entry) throws JsonProcessingException {
        JsonNode credentialJson = (JsonNode)entry.content();
        if (!credentialJson.isObject()) {
            throw this.newInvalidJsonTypeException(credentialFile, credentialJson);
        }
        return (Credential)Jackson.treeToValue((TreeNode)credentialJson, Credential.class);
    }

    private RepositoryMetadataException newInvalidJsonTypeException(String fileName, JsonNode credentialJson) {
        return new RepositoryMetadataException(this.parent().name() + "/" + this.name() + fileName + " must be an object: " + String.valueOf(credentialJson.getNodeType()));
    }

    private CompletableFuture<Map<String, Entry<?>>> find(String filePattern) {
        return this.find(Revision.HEAD, filePattern, (Map<FindOption<?>, ?>)ImmutableMap.of());
    }

    @Override
    public CompletableFuture<Command<CommitResult>> createMirrorPushCommand(String repoName, MirrorRequest mirrorRequest, Author author, @Nullable ZoneConfig zoneConfig, boolean update) {
        DefaultMetaRepository.validateMirror(mirrorRequest, zoneConfig);
        if (update) {
            String summary = "Update the mirror '" + mirrorRequest.id() + "' in " + repoName;
            return this.mirror(repoName, mirrorRequest.id()).thenApply(mirror -> this.newMirrorCommand(repoName, mirrorRequest, author, summary));
        }
        String summary = "Create a new mirror from " + mirrorRequest.remoteUrl() + mirrorRequest.remotePath() + "#" + mirrorRequest.remoteBranch() + " into " + repoName + mirrorRequest.localPath();
        summary = MirrorDirection.valueOf(mirrorRequest.direction()) == MirrorDirection.REMOTE_TO_LOCAL ? "[Remote-to-local] " + summary : "[Local-to-remote] " + summary;
        return UnmodifiableFuture.completedFuture(this.newMirrorCommand(repoName, mirrorRequest, author, summary));
    }

    @Override
    public CompletableFuture<Command<CommitResult>> createCredentialPushCommand(Credential credential, Author author, boolean update) {
        String credentialName = credential.name();
        if (update) {
            return this.credential(credentialName).thenApply(c -> {
                String summary = "Update the mirror credential '" + credentialName + "'";
                return this.newCredentialCommand(CredentialUtil.credentialFile((String)credentialName), credential, author, summary);
            });
        }
        String summary = "Create a new mirror credential for " + credential.name();
        return UnmodifiableFuture.completedFuture(this.newCredentialCommand(CredentialUtil.credentialFile((String)credentialName), credential, author, summary));
    }

    @Override
    public CompletableFuture<Command<CommitResult>> createCredentialPushCommand(String repoName, Credential credential, Author author, boolean update) {
        String credentialName = credential.name();
        if (update) {
            return this.credential(credentialName).thenApply(c -> {
                String summary = "Update the mirror credential '" + credentialName + "'";
                return this.newCredentialCommand(CredentialUtil.credentialFile((String)credentialName), credential, author, summary);
            });
        }
        String summary = "Create a new mirror credential '" + credentialName + "'";
        return UnmodifiableFuture.completedFuture(this.newCredentialCommand(CredentialUtil.credentialFile((String)credentialName), credential, author, summary));
    }

    private Command<CommitResult> newCredentialCommand(String credentialFile, Credential credential, Author author, String summary) {
        JsonNode jsonNode = Jackson.valueToTree((Object)credential);
        Change change = Change.ofJsonUpsert((String)credentialFile, (JsonNode)jsonNode);
        return Command.push(author, this.parent().name(), this.name(), Revision.HEAD, summary, "", Markup.PLAINTEXT, change);
    }

    private Command<CommitResult> newMirrorCommand(String repoName, MirrorRequest mirrorRequest, Author author, String summary) {
        MirrorConfig mirrorConfig = MirrorConverter.converterToMirrorConfig(mirrorRequest);
        JsonNode jsonNode = Jackson.valueToTree((Object)mirrorConfig);
        Change change = Change.ofJsonUpsert((String)DefaultMetaRepository.mirrorFile(repoName, mirrorConfig.id()), (JsonNode)jsonNode);
        return Command.push(author, this.parent().name(), this.name(), Revision.HEAD, summary, "", Markup.PLAINTEXT, change);
    }

    private static void validateMirror(MirrorRequest mirror, @Nullable ZoneConfig zoneConfig) {
        String zone;
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)mirror.id()) ? 1 : 0) != 0, (Object)"Mirror ID is empty");
        String scheduleString = mirror.schedule();
        if (scheduleString != null) {
            Cron schedule = MirrorConfig.CRON_PARSER.parse(scheduleString);
            CronField secondField = schedule.retrieve(CronFieldName.SECOND);
            Preconditions.checkArgument((!secondField.getExpression().asString().contains("*") ? 1 : 0) != 0, (Object)"The second field of the schedule must be specified. (seconds: *, expected: 0-59)");
        }
        if ((zone = mirror.zone()) != null) {
            Preconditions.checkArgument((zoneConfig != null ? 1 : 0) != 0, (Object)"Zone configuration is missing");
            Preconditions.checkArgument((boolean)zoneConfig.allZones().contains(zone), (String)"The zone '%s' is not in the zone configuration: %s", (Object)zone, (Object)zoneConfig);
        }
    }
}

