/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.storage;

import com.linecorp.centraldogma.common.Author;
import com.linecorp.centraldogma.internal.shaded.guava.annotations.VisibleForTesting;
import com.linecorp.centraldogma.internal.shaded.guava.base.Preconditions;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.centraldogma.internal.shaded.guava.util.concurrent.FutureCallback;
import com.linecorp.centraldogma.internal.shaded.guava.util.concurrent.Futures;
import com.linecorp.centraldogma.internal.shaded.guava.util.concurrent.ListenableFuture;
import com.linecorp.centraldogma.internal.shaded.guava.util.concurrent.ListenableScheduledFuture;
import com.linecorp.centraldogma.internal.shaded.guava.util.concurrent.ListeningScheduledExecutorService;
import com.linecorp.centraldogma.internal.shaded.guava.util.concurrent.MoreExecutors;
import com.linecorp.centraldogma.server.command.Command;
import com.linecorp.centraldogma.server.command.CommandExecutor;
import com.linecorp.centraldogma.server.internal.ExecutorServiceUtil;
import com.linecorp.centraldogma.server.metadata.MetadataService;
import com.linecorp.centraldogma.server.metadata.Token;
import com.linecorp.centraldogma.server.metadata.Tokens;
import com.linecorp.centraldogma.server.storage.project.ProjectManager;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PurgeSchedulingService {
    private static final Logger logger = LoggerFactory.getLogger(PurgeSchedulingService.class);
    private static final Duration TICK = Duration.ofMinutes(1L);
    private final ProjectManager projectManager;
    private final ScheduledExecutorService purgeWorker;
    private final long maxRemovedRepositoryAgeMillis;
    private final StoragePurgingScheduler storagePurgingScheduler = new StoragePurgingScheduler();

    public PurgeSchedulingService(ProjectManager projectManager, ScheduledExecutorService purgeWorker, long maxRemovedRepositoryAgeMillis) {
        this.projectManager = Objects.requireNonNull(projectManager, "projectManager");
        this.purgeWorker = Objects.requireNonNull(purgeWorker, "purgeWorker");
        Preconditions.checkArgument((maxRemovedRepositoryAgeMillis >= 0L ? 1 : 0) != 0, (String)"maxRemovedRepositoryAgeMillis: %s (expected: >= 0)", (long)maxRemovedRepositoryAgeMillis);
        this.maxRemovedRepositoryAgeMillis = maxRemovedRepositoryAgeMillis;
    }

    public void start(CommandExecutor commandExecutor, MetadataService metadataService) {
        if (this.isDisabled()) {
            return;
        }
        Objects.requireNonNull(commandExecutor, "commandExecutor");
        Objects.requireNonNull(metadataService, "metadataService");
        this.cleanPurgedFiles();
        this.storagePurgingScheduler.start(() -> {
            try {
                this.purgeProjectAndRepository(commandExecutor, metadataService);
                PurgeSchedulingService.purgeToken(metadataService);
            }
            catch (Exception e) {
                logger.warn("Unexpected purging service failure", (Throwable)e);
            }
        });
    }

    public boolean isStarted() {
        return this.storagePurgingScheduler.isStarted();
    }

    public void stop() {
        if (!this.isDisabled()) {
            this.storagePurgingScheduler.stop();
        }
    }

    private void cleanPurgedFiles() {
        this.projectManager.purgeMarked();
        this.projectManager.list().forEach((unused, project) -> project.repos().purgeMarked());
    }

    @VisibleForTesting
    void purgeProjectAndRepository(CommandExecutor commandExecutor, MetadataService metadataService) {
        long minAllowedTimestamp = System.currentTimeMillis() - this.maxRemovedRepositoryAgeMillis;
        Predicate<Instant> olderThanMinAllowed = removedAt -> removedAt.toEpochMilli() < minAllowedTimestamp;
        this.purgeProject(commandExecutor, olderThanMinAllowed);
        this.purgeRepository(commandExecutor, metadataService, olderThanMinAllowed);
    }

    private void purgeProject(CommandExecutor commandExecutor, Predicate<Instant> olderThanMinAllowed) {
        this.projectManager.listRemoved().forEach((projectName, removal) -> {
            if (olderThanMinAllowed.test((Instant)removal)) {
                commandExecutor.execute(Command.purgeProject(Author.SYSTEM, projectName)).join();
            }
        });
    }

    private void purgeRepository(CommandExecutor commandExecutor, MetadataService metadataService, Predicate<Instant> olderThanMinAllowed) {
        this.projectManager.list().forEach((unused, project) -> project.repos().listRemoved().forEach((repoName, removal) -> {
            if (olderThanMinAllowed.test((Instant)removal)) {
                commandExecutor.execute(Command.purgeRepository(Author.SYSTEM, project.name(), repoName)).join();
                metadataService.purgeRepo(Author.SYSTEM, project.name(), (String)repoName).join();
            }
        }));
    }

    private static void purgeToken(MetadataService metadataService) {
        Tokens tokens = metadataService.getTokens();
        List purging = (List)tokens.appIds().values().stream().filter(Token::isDeleted).map(Token::appId).collect(ImmutableList.toImmutableList());
        if (!purging.isEmpty()) {
            logger.info("Purging {} tokens: {}", (Object)purging.size(), (Object)purging);
            purging.forEach(appId -> metadataService.purgeToken(Author.SYSTEM, (String)appId));
        }
    }

    private boolean isDisabled() {
        return this.maxRemovedRepositoryAgeMillis == 0L;
    }

    private final class StoragePurgingScheduler {
        @Nullable
        private volatile ListeningScheduledExecutorService scheduler;

        private StoragePurgingScheduler() {
        }

        public boolean isStarted() {
            return this.scheduler != null;
        }

        public synchronized void start(Runnable task) {
            ListeningScheduledExecutorService scheduler;
            if (this.isStarted()) {
                return;
            }
            Objects.requireNonNull(task, "task");
            this.scheduler = scheduler = MoreExecutors.listeningDecorator((ScheduledExecutorService)PurgeSchedulingService.this.purgeWorker);
            ListenableScheduledFuture future = scheduler.scheduleWithFixedDelay(task, TICK.getSeconds(), TICK.getSeconds(), TimeUnit.SECONDS);
            Futures.addCallback((ListenableFuture)future, (FutureCallback)new FutureCallback<Object>(){

                public void onSuccess(@Nullable Object result) {
                }

                public void onFailure(Throwable cause) {
                    logger.error("Storage purge scheduler stopped due to an unexpected exception:", cause);
                }
            }, (Executor)PurgeSchedulingService.this.purgeWorker);
        }

        public synchronized void stop() {
            ListeningScheduledExecutorService scheduler = this.scheduler;
            try {
                boolean interrupted = ExecutorServiceUtil.terminate((ExecutorService)scheduler);
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
            finally {
                this.scheduler = null;
            }
        }
    }
}

