/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.storage;

import com.linecorp.armeria.common.util.SystemInfo;
import java.security.Key;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.conscrypt.Conscrypt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AesGcmSivCipher {
    private static final Logger logger = LoggerFactory.getLogger(AesGcmSivCipher.class);
    private static final String ALGORITHM = "AES/GCM-SIV/NoPadding";
    public static final int KEY_SIZE_BYTES = 32;
    public static final int NONCE_SIZE_BYTES = 12;
    private static final int TAG_SIZE_BITS = 128;
    private static final SecureRandom SECURE_RANDOM = new SecureRandom();
    private static final String PROVIDER;

    public static byte[] generateAes256Key() {
        byte[] keyBytes = new byte[32];
        SECURE_RANDOM.nextBytes(keyBytes);
        return keyBytes;
    }

    public static SecretKeySpec aesSecretKey(byte[] key) {
        return new SecretKeySpec(key, "AES");
    }

    public static byte[] generateNonce() {
        byte[] nonce = new byte[12];
        SECURE_RANDOM.nextBytes(nonce);
        return nonce;
    }

    public static byte[] encrypt(SecretKey key, byte[] nonce, byte[] data) throws Exception {
        return AesGcmSivCipher.encrypt(key, nonce, data, 0, data.length);
    }

    public static byte[] encrypt(SecretKey key, byte[] nonce, byte[] data, int off, int len) throws Exception {
        Cipher cipher = Cipher.getInstance(ALGORITHM, PROVIDER);
        GCMParameterSpec parameterSpec = new GCMParameterSpec(128, nonce);
        cipher.init(1, (Key)key, parameterSpec);
        return cipher.doFinal(data, off, len);
    }

    public static byte[] decrypt(SecretKey key, byte[] nonce, byte[] ciphertext) throws Exception {
        Cipher cipher = Cipher.getInstance(ALGORITHM, PROVIDER);
        GCMParameterSpec parameterSpec = new GCMParameterSpec(128, nonce);
        cipher.init(2, (Key)key, parameterSpec);
        return cipher.doFinal(ciphertext);
    }

    private AesGcmSivCipher() {
    }

    static {
        if (SystemInfo.isLinux()) {
            Security.addProvider(Conscrypt.newProvider());
            PROVIDER = "Conscrypt";
        } else {
            Security.addProvider((Provider)new BouncyCastleProvider());
            PROVIDER = "BC";
        }
        logger.info("Using cryptographic provider: {}", (Object)PROVIDER);
    }
}

