/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.replication;

import com.linecorp.armeria.common.metric.MoreMeters;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableList;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Timer;

final class ReplicationMetrics {
    private final String projectName;
    private final Timer executorQueueLatencyTimer;
    private final Timer lockAcquireSuccessTimer;
    private final Timer lockAcquireFailureTimer;
    private final Timer lockReleaseTimer;
    private final Timer commandExecutionTimer;
    private final Timer logReplayTimer;
    private final Timer logStoreTimer;

    ReplicationMetrics(MeterRegistry registry, String projectName) {
        this.projectName = projectName;
        this.executorQueueLatencyTimer = MoreMeters.newTimer((MeterRegistry)registry, (String)"replication.executor.queue.latency", (Iterable)ImmutableList.of((Object)Tag.of((String)"project", (String)projectName)));
        this.lockAcquireSuccessTimer = MoreMeters.newTimer((MeterRegistry)registry, (String)"replication.lock.acquisition", (Iterable)ImmutableList.of((Object)Tag.of((String)"project", (String)projectName), (Object)Tag.of((String)"acquired", (String)"true")));
        this.lockAcquireFailureTimer = MoreMeters.newTimer((MeterRegistry)registry, (String)"replication.lock.acquisition", (Iterable)ImmutableList.of((Object)Tag.of((String)"project", (String)projectName), (Object)Tag.of((String)"acquired", (String)"false")));
        this.lockReleaseTimer = MoreMeters.newTimer((MeterRegistry)registry, (String)"replication.lock.release", (Iterable)ImmutableList.of((Object)Tag.of((String)"project", (String)projectName)));
        this.commandExecutionTimer = MoreMeters.newTimer((MeterRegistry)registry, (String)"replication.command.execution", (Iterable)ImmutableList.of((Object)Tag.of((String)"project", (String)projectName)));
        this.logReplayTimer = MoreMeters.newTimer((MeterRegistry)registry, (String)"replication.log.replay", (Iterable)ImmutableList.of((Object)Tag.of((String)"project", (String)projectName)));
        this.logStoreTimer = MoreMeters.newTimer((MeterRegistry)registry, (String)"replication.log.store", (Iterable)ImmutableList.of((Object)Tag.of((String)"project", (String)projectName)));
    }

    Timer executorQueueLatencyTimer() {
        return this.executorQueueLatencyTimer;
    }

    Timer lockAcquireSuccessTimer() {
        return this.lockAcquireSuccessTimer;
    }

    Timer lockAcquireFailureTimer() {
        return this.lockAcquireFailureTimer;
    }

    Timer lockReleaseTimer() {
        return this.lockReleaseTimer;
    }

    Timer commandExecutionTimer() {
        return this.commandExecutionTimer;
    }

    Timer logReplayTimer() {
        return this.logReplayTimer;
    }

    Timer logStoreTimer() {
        return this.logStoreTimer;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ReplicationMetrics)) {
            return false;
        }
        ReplicationMetrics that = (ReplicationMetrics)o;
        return this.projectName.equals(that.projectName);
    }

    public int hashCode() {
        return this.projectName.hashCode();
    }
}

