/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.replication;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.linecorp.centraldogma.internal.shaded.guava.base.MoreObjects;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
class LogMeta {
    private final int replicaId;
    private final long timestamp;
    private final int size;
    @Nullable
    private final Boolean compressed;
    @Nullable
    private final Boolean encrypted;
    private final List<Long> blocks;

    @JsonCreator
    LogMeta(@JsonProperty(value="replicaId", required=true) int replicaId, @JsonProperty(value="timestamp", defaultValue="0") @Nullable Long timestamp, @JsonProperty(value="size") int size, @JsonProperty(value="blocks") List<Long> blocks, @Nullable @JsonProperty(value="compressed") Boolean compressed, @Nullable @JsonProperty(value="encrypted") Boolean encrypted) {
        this.replicaId = replicaId;
        if (timestamp == null) {
            timestamp = 0L;
        }
        this.timestamp = timestamp;
        this.size = size;
        this.compressed = compressed;
        this.encrypted = encrypted;
        this.blocks = blocks;
    }

    LogMeta(int replicaId, Long timestamp, int size, @Nullable Boolean compressed, @Nullable Boolean encrypted) {
        this(replicaId, timestamp, size, new ArrayList<Long>(4), compressed, encrypted);
    }

    @JsonProperty
    int replicaId() {
        return this.replicaId;
    }

    @JsonProperty
    long timestamp() {
        return this.timestamp;
    }

    @JsonProperty
    int size() {
        return this.size;
    }

    @Nullable
    @JsonProperty(value="compressed")
    Boolean compressed() {
        return this.compressed;
    }

    @Nullable
    @JsonProperty(value="encrypted")
    Boolean encrypted() {
        return this.encrypted;
    }

    @JsonProperty
    List<Long> blocks() {
        return Collections.unmodifiableList(this.blocks);
    }

    public void appendBlock(long blockId) {
        this.blocks.add(blockId);
    }

    public boolean equals(Object o) {
        if (!(o instanceof LogMeta)) {
            return false;
        }
        LogMeta logMeta = (LogMeta)o;
        return this.replicaId == logMeta.replicaId && this.timestamp == logMeta.timestamp && this.size == logMeta.size && Objects.equals(this.compressed, logMeta.compressed) && Objects.equals(this.encrypted, logMeta.encrypted) && Objects.equals(this.blocks, logMeta.blocks);
    }

    public int hashCode() {
        return Objects.hash(this.replicaId, this.timestamp, this.size, this.compressed, this.encrypted, this.blocks);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("replicaId", this.replicaId).add("timestamp", this.timestamp).add("size", this.size).add("compressed", (Object)this.compressed).add("encrypted", (Object)this.encrypted).add("blocks", this.blocks).toString();
    }
}

