/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.mirror;

import com.linecorp.centraldogma.server.metadata.User;
import com.linecorp.centraldogma.server.mirror.Mirror;
import com.linecorp.centraldogma.server.mirror.MirrorAccessController;
import com.linecorp.centraldogma.server.mirror.MirrorListener;
import com.linecorp.centraldogma.server.mirror.MirrorResult;
import com.linecorp.centraldogma.server.mirror.MirrorTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

enum DefaultMirrorListener implements MirrorListener
{
    INSTANCE;

    private static final Logger logger;

    @Override
    public void onCreate(Mirror mirror, User creator, MirrorAccessController accessController) {
        logger.debug("A new mirroring from {} is created. mirror: {}", (Object)mirror.remoteRepoUri(), (Object)mirror);
    }

    @Override
    public void onUpdate(Mirror mirror, User updater, MirrorAccessController accessController) {
        logger.debug("The mirroring ID {} is updated. mirror: {}", (Object)mirror.id(), (Object)mirror);
    }

    @Override
    public void onDisallowed(Mirror mirror) {
        logger.debug("The mirroring from {} is not allowed. mirror: {}", (Object)mirror.remoteRepoUri(), (Object)mirror);
    }

    @Override
    public void onStart(MirrorTask mirrorTask) {
        if (mirrorTask.scheduled()) {
            logger.info("Mirroring: {}", (Object)mirrorTask);
        }
    }

    @Override
    public void onComplete(MirrorTask mirrorTask, MirrorResult result) {
    }

    @Override
    public void onError(MirrorTask mirrorTask, Throwable cause) {
        if (mirrorTask.scheduled()) {
            logger.warn("Unexpected exception while mirroring: {}", (Object)mirrorTask, (Object)cause);
        }
    }

    static {
        logger = LoggerFactory.getLogger(DefaultMirrorListener.class);
    }
}

