/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.mirror;

import com.linecorp.centraldogma.common.Author;
import com.linecorp.centraldogma.common.MirrorException;
import com.linecorp.centraldogma.internal.shaded.cronutils.descriptor.CronDescriptor;
import com.linecorp.centraldogma.internal.shaded.cronutils.model.Cron;
import com.linecorp.centraldogma.internal.shaded.cronutils.model.time.ExecutionTime;
import com.linecorp.centraldogma.internal.shaded.guava.annotations.VisibleForTesting;
import com.linecorp.centraldogma.internal.shaded.guava.base.MoreObjects;
import com.linecorp.centraldogma.server.command.CommandExecutor;
import com.linecorp.centraldogma.server.credential.Credential;
import com.linecorp.centraldogma.server.mirror.Mirror;
import com.linecorp.centraldogma.server.mirror.MirrorDirection;
import com.linecorp.centraldogma.server.mirror.MirrorResult;
import com.linecorp.centraldogma.server.mirror.MirrorStatus;
import com.linecorp.centraldogma.server.mirror.MirrorUtil;
import com.linecorp.centraldogma.server.storage.repository.Repository;
import java.io.File;
import java.net.URI;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public abstract class AbstractMirror
implements Mirror {
    private static final CronDescriptor CRON_DESCRIPTOR = CronDescriptor.instance();
    protected static final Author MIRROR_AUTHOR = new Author("Mirror", "mirror@localhost.localdomain");
    private final String id;
    private final boolean enabled;
    private final MirrorDirection direction;
    private final Credential credential;
    private final Repository localRepo;
    private final String localPath;
    private final URI remoteRepoUri;
    private final String remotePath;
    private final String remoteBranch;
    @Nullable
    private final String gitignore;
    @Nullable
    private final String zone;
    @Nullable
    private final Cron schedule;
    @Nullable
    private final ExecutionTime executionTime;
    private final long jitterMillis;

    protected AbstractMirror(String id, boolean enabled, @Nullable Cron schedule, MirrorDirection direction, Credential credential, Repository localRepo, String localPath, URI remoteRepoUri, String remotePath, String remoteBranch, @Nullable String gitignore, @Nullable String zone) {
        this.id = Objects.requireNonNull(id, "id");
        this.enabled = enabled;
        this.direction = Objects.requireNonNull(direction, "direction");
        this.credential = Objects.requireNonNull(credential, "credential");
        this.localRepo = Objects.requireNonNull(localRepo, "localRepo");
        this.localPath = MirrorUtil.normalizePath(Objects.requireNonNull(localPath, "localPath"));
        this.remoteRepoUri = Objects.requireNonNull(remoteRepoUri, "remoteRepoUri");
        this.remotePath = MirrorUtil.normalizePath(Objects.requireNonNull(remotePath, "remotePath"));
        this.remoteBranch = Objects.requireNonNull(remoteBranch, "remoteBranch");
        this.gitignore = gitignore;
        this.zone = zone;
        if (schedule != null) {
            this.schedule = Objects.requireNonNull(schedule, "schedule");
            this.executionTime = ExecutionTime.forCron((Cron)this.schedule);
            this.jitterMillis = Math.abs(Objects.hash(new Object[]{this.schedule.asString(), this.direction, this.localRepo.parent().name(), this.localRepo.name(), this.remoteRepoUri, this.remotePath, this.remoteBranch}) / 35791);
        } else {
            this.schedule = null;
            this.executionTime = null;
            this.jitterMillis = -1L;
        }
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public final Cron schedule() {
        return this.schedule;
    }

    @Override
    public final ZonedDateTime nextExecutionTime(ZonedDateTime lastExecutionTime) {
        return this.nextExecutionTime(lastExecutionTime, this.jitterMillis);
    }

    @VisibleForTesting
    ZonedDateTime nextExecutionTime(ZonedDateTime lastExecutionTime, long jitterMillis) {
        Objects.requireNonNull(lastExecutionTime, "lastExecutionTime");
        Optional next = this.executionTime.nextExecution(lastExecutionTime.minus(jitterMillis, ChronoUnit.MILLIS));
        if (next.isPresent()) {
            return ((ZonedDateTime)next.get()).plus(jitterMillis, ChronoUnit.MILLIS);
        }
        throw new IllegalArgumentException("no next execution time for " + CRON_DESCRIPTOR.describe(this.schedule) + ", lastExecutionTime: " + String.valueOf(lastExecutionTime));
    }

    @Override
    public MirrorDirection direction() {
        return this.direction;
    }

    @Override
    public final Credential credential() {
        return this.credential;
    }

    @Override
    public final Repository localRepo() {
        return this.localRepo;
    }

    @Override
    public final String localPath() {
        return this.localPath;
    }

    @Override
    public final URI remoteRepoUri() {
        return this.remoteRepoUri;
    }

    @Override
    public final String remotePath() {
        return this.remotePath;
    }

    @Override
    public final String remoteBranch() {
        return this.remoteBranch;
    }

    @Override
    public final String gitignore() {
        return this.gitignore;
    }

    @Override
    public final boolean enabled() {
        return this.enabled;
    }

    @Override
    @Nullable
    public String zone() {
        return this.zone;
    }

    @Override
    public final MirrorResult mirror(File workDir, CommandExecutor executor, int maxNumFiles, long maxNumBytes, Instant triggeredTime) {
        try {
            switch (this.direction()) {
                case LOCAL_TO_REMOTE: {
                    return this.mirrorLocalToRemote(workDir, maxNumFiles, maxNumBytes, triggeredTime);
                }
                case REMOTE_TO_LOCAL: {
                    return this.mirrorRemoteToLocal(workDir, executor, maxNumFiles, maxNumBytes, triggeredTime);
                }
            }
            throw new Error("Should never reach here");
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new MirrorException((Throwable)e);
        }
        catch (MirrorException e) {
            throw e;
        }
        catch (Exception e) {
            String message = e.getMessage();
            if (message != null) {
                throw new MirrorException(message, (Throwable)e);
            }
            throw new MirrorException((Throwable)e);
        }
    }

    protected abstract MirrorResult mirrorLocalToRemote(File var1, int var2, long var3, Instant var5) throws Exception;

    protected abstract MirrorResult mirrorRemoteToLocal(File var1, CommandExecutor var2, int var3, long var4, Instant var6) throws Exception;

    protected final MirrorResult newMirrorResult(MirrorStatus mirrorStatus, @Nullable String description, Instant triggeredTime) {
        return new MirrorResult(this.id, this.localRepo.parent().name(), this.localRepo.name(), mirrorStatus, description, triggeredTime, Instant.now(), this.zone);
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"").omitNullValues().add("direction", (Object)this.direction).add("localProj", (Object)this.localRepo.parent().name()).add("localRepo", (Object)this.localRepo.name()).add("localPath", (Object)this.localPath).add("remoteRepo", (Object)this.remoteRepoUri).add("remotePath", (Object)this.remotePath).add("remoteBranch", (Object)this.remoteBranch).add("gitignore", (Object)this.gitignore).add("credential", (Object)this.credential);
        if (this.schedule != null) {
            helper.add("schedule", (Object)CronDescriptor.instance().describe(this.schedule));
        }
        return helper.toString();
    }
}

