/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.api.sysadmin;

import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.annotation.Blocking;
import com.linecorp.armeria.server.annotation.Default;
import com.linecorp.armeria.server.annotation.Get;
import com.linecorp.armeria.server.annotation.Param;
import com.linecorp.armeria.server.annotation.Post;
import com.linecorp.armeria.server.annotation.ProducesJson;
import com.linecorp.armeria.server.annotation.decorator.RequestTimeout;
import com.linecorp.centraldogma.common.Author;
import com.linecorp.centraldogma.internal.shaded.guava.base.Preconditions;
import com.linecorp.centraldogma.server.auth.SessionMasterKey;
import com.linecorp.centraldogma.server.command.Command;
import com.linecorp.centraldogma.server.command.CommandExecutor;
import com.linecorp.centraldogma.server.internal.api.AbstractService;
import com.linecorp.centraldogma.server.internal.api.auth.RequiresSystemAdministrator;
import com.linecorp.centraldogma.server.internal.api.sysadmin.SessionMasterKeyDto;
import com.linecorp.centraldogma.server.storage.encryption.EncryptionStorageManager;
import com.linecorp.centraldogma.server.storage.encryption.SecretKeyWithVersion;
import com.linecorp.centraldogma.server.storage.encryption.WrappedDekDetails;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

@ProducesJson
@RequiresSystemAdministrator
public final class KeyManagementService
extends AbstractService {
    private final EncryptionStorageManager encryptionStorageManager;

    public KeyManagementService(CommandExecutor executor, EncryptionStorageManager encryptionStorageManager) {
        super(executor);
        Objects.requireNonNull(encryptionStorageManager, "encryptionStorageManager");
        Preconditions.checkArgument((boolean)encryptionStorageManager.enabled(), (Object)"EncryptionStorageManager must be enabled.");
        this.encryptionStorageManager = encryptionStorageManager;
    }

    @Get(value="/wdeks")
    @Blocking
    public List<WrappedDekDetails> listWdeks() {
        return this.encryptionStorageManager.wdeks();
    }

    @Post(value="/projects/{projectName}/repos/{repoName}/wdeks/rotate")
    @Blocking
    public CompletableFuture<Void> rotateWdek(@Param String projectName, @Param String repoName, @Param @Default(value="false") boolean reencrypt, Author author, ServiceRequestContext ctx) {
        Objects.requireNonNull(projectName, "projectName");
        Objects.requireNonNull(repoName, "repoName");
        if (reencrypt) {
            ctx.setRequestTimeout(Duration.ofSeconds(60L));
        }
        SecretKeyWithVersion currentDek = this.encryptionStorageManager.getCurrentDek(projectName, repoName);
        return this.encryptionStorageManager.generateWdek().thenCompose(wdek -> {
            int newVersion = currentDek.version() + 1;
            WrappedDekDetails wdekDetails = new WrappedDekDetails((String)wdek, newVersion, this.encryptionStorageManager.kekId(), projectName, repoName);
            return this.execute(Command.rotateWdek(author, projectName, repoName, wdekDetails, reencrypt));
        });
    }

    @Get(value="/masterkeys/session")
    @Blocking
    public SessionMasterKeyDto getSessionMasterKeyDetails() {
        if (!this.encryptionStorageManager.encryptSessionCookie()) {
            throw new IllegalStateException("Session cookie encryption is disabled.");
        }
        SessionMasterKey sessionMasterKey = this.encryptionStorageManager.getCurrentSessionMasterKey();
        return new SessionMasterKeyDto(sessionMasterKey.version(), sessionMasterKey.kekId(), sessionMasterKey.creationInstant());
    }

    @Post(value="/masterkeys/session/rotate")
    @Blocking
    public CompletableFuture<Void> rotateSessionMasterKey(Author author) {
        if (!this.encryptionStorageManager.encryptSessionCookie()) {
            throw new IllegalStateException("Session cookie encryption is disabled.");
        }
        SessionMasterKey currentSessionMasterKey = this.encryptionStorageManager.getCurrentSessionMasterKey();
        SessionMasterKey newSessionMasterKey = this.encryptionStorageManager.generateSessionMasterKey(currentSessionMasterKey.version() + 1).join();
        return this.execute(Command.rotateSessionMasterKey(author, newSessionMasterKey));
    }

    @Post(value="/keys/rewrap")
    @Blocking
    @RequestTimeout(value=60000L)
    public CompletableFuture<Void> rewrapAllKeys(Author author) {
        return this.execute(Command.rewrapAllKeys(author));
    }
}

