/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.api.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.linecorp.armeria.common.AggregatedHttpRequest;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.annotation.JacksonRequestConverterFunction;
import com.linecorp.armeria.server.annotation.RequestConverterFunction;
import com.linecorp.centraldogma.common.Change;
import com.linecorp.centraldogma.common.ChangeType;
import com.linecorp.centraldogma.internal.shaded.guava.base.Preconditions;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableList;
import java.lang.reflect.ParameterizedType;
import java.util.List;
import javax.annotation.Nullable;

public final class ChangesRequestConverter
implements RequestConverterFunction {
    private final JacksonRequestConverterFunction delegate = new JacksonRequestConverterFunction();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<Change<?>> convertRequest(ServiceRequestContext ctx, AggregatedHttpRequest request, Class<?> expectedResultType, @Nullable ParameterizedType expectedParameterizedResultType) throws Exception {
        ArrayNode changesNode;
        JsonNode node = (JsonNode)this.delegate.convertRequest(ctx, request, JsonNode.class, null);
        if (node == null) {
            return (List)RequestConverterFunction.fallthrough();
        }
        if (node.getNodeType() == JsonNodeType.ARRAY) {
            changesNode = (ArrayNode)node;
        } else {
            JsonNode maybeChangesNode = node.get("changes");
            if (maybeChangesNode == null) return ImmutableList.of(ChangesRequestConverter.readChange(node));
            if (maybeChangesNode.getNodeType() != JsonNodeType.ARRAY) throw new IllegalArgumentException("'changes' must be an array.");
            changesNode = (ArrayNode)maybeChangesNode;
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (JsonNode change : changesNode) {
            builder.add(ChangesRequestConverter.readChange(change));
        }
        return builder.build();
    }

    private static Change<?> readChange(JsonNode node) {
        Preconditions.checkArgument((node.get("path") != null && node.get("type") != null ? 1 : 0) != 0, (Object)"a change should have a path and a type");
        ChangeType changeType = ChangeType.parse((String)node.get("type").textValue());
        if (changeType != ChangeType.REMOVE) {
            if (changeType == ChangeType.UPSERT_JSON || changeType == ChangeType.UPSERT_TEXT) {
                Preconditions.checkArgument((node.get("content") != null || node.get("rawContent") != null ? 1 : 0) != 0, (Object)"a change should have a content.");
            } else {
                Preconditions.checkArgument((node.get("content") != null ? 1 : 0) != 0, (Object)"a change should have a content.");
            }
        }
        String path = node.get("path").textValue();
        if (changeType == ChangeType.UPSERT_TEXT) {
            JsonNode content = node.get("content");
            if (content != null) {
                return Change.ofTextUpsert((String)path, (String)content.textValue());
            }
            return Change.ofTextUpsert((String)path, (String)node.get("rawContent").textValue());
        }
        if (changeType == ChangeType.UPSERT_JSON) {
            JsonNode content = node.get("content");
            if (content != null) {
                return Change.ofJsonUpsert((String)path, (JsonNode)content);
            }
            return Change.ofJsonUpsert((String)path, (String)node.get("rawContent").textValue());
        }
        if (changeType == ChangeType.REMOVE) {
            return Change.ofRemoval((String)path);
        }
        if (changeType == ChangeType.RENAME) {
            return Change.ofRename((String)path, (String)node.get("content").textValue());
        }
        if (changeType == ChangeType.APPLY_TEXT_PATCH) {
            return Change.ofTextPatch((String)path, (String)node.get("content").textValue());
        }
        if (changeType == ChangeType.APPLY_JSON_PATCH) {
            return Change.ofJsonPatch((String)path, (JsonNode)node.get("content"));
        }
        throw new Error();
    }
}

