/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.api.auth;

import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.Request;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.armeria.server.HttpService;
import com.linecorp.armeria.server.Service;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.SimpleDecoratingHttpService;
import com.linecorp.armeria.server.annotation.DecoratorFactoryFunction;
import com.linecorp.centraldogma.common.RepositoryRole;
import com.linecorp.centraldogma.internal.shaded.guava.base.Preconditions;
import com.linecorp.centraldogma.internal.shaded.guava.base.Strings;
import com.linecorp.centraldogma.server.internal.admin.auth.AuthUtil;
import com.linecorp.centraldogma.server.internal.api.HttpApiUtil;
import com.linecorp.centraldogma.server.internal.api.auth.RequiresProjectRoleDecorator;
import com.linecorp.centraldogma.server.internal.api.auth.RequiresRepositoryRole;
import com.linecorp.centraldogma.server.metadata.MetadataService;
import com.linecorp.centraldogma.server.metadata.User;
import com.linecorp.centraldogma.server.storage.project.Project;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class RequiresRepositoryRoleDecorator
extends SimpleDecoratingHttpService {
    private final MetadataService mds;
    private final RepositoryRole requiredRole;
    @Nullable
    private final String projectName;
    @Nullable
    private final String repoName;

    RequiresRepositoryRoleDecorator(HttpService delegate, MetadataService mds, RepositoryRole requiredRole, @Nullable String projectName, @Nullable String repoName) {
        super(delegate);
        this.mds = Objects.requireNonNull(mds, "mds");
        this.requiredRole = Objects.requireNonNull(requiredRole, "requiredRole");
        this.projectName = projectName;
        this.repoName = repoName;
    }

    public HttpResponse serve(ServiceRequestContext ctx, HttpRequest req) throws Exception {
        User user = AuthUtil.currentUser(ctx);
        String projectName = this.projectName;
        if (projectName == null) {
            projectName = ctx.pathParam("projectName");
        }
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)projectName) ? 1 : 0) != 0, (Object)"no project name is specified");
        String repoName = this.repoName;
        if (repoName == null) {
            repoName = ctx.pathParam("repoName");
        }
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)repoName) ? 1 : 0) != 0, (Object)"no repository name is specified");
        if (user.isSystemAdmin()) {
            return (HttpResponse)((Service)this.unwrap()).serve(ctx, (Request)req);
        }
        if (Project.isInternalRepo(repoName)) {
            return RequiresRepositoryRoleDecorator.throwForbiddenResponse(ctx, projectName, repoName);
        }
        return this.serveUserRepo(ctx, req, user, projectName, RequiresRepositoryRoleDecorator.maybeRemoveGitSuffix(repoName));
    }

    private static HttpResponse throwForbiddenResponse(ServiceRequestContext ctx, String projectName, String repoName) {
        return (HttpResponse)HttpApiUtil.throwResponse(ctx, HttpStatus.FORBIDDEN, "Repository '%s/%s' can be accessed only by a system administrator.", projectName, repoName);
    }

    private static String maybeRemoveGitSuffix(String repoName) {
        if (repoName.length() >= 5 && repoName.endsWith(".git")) {
            repoName = repoName.substring(0, repoName.length() - 4);
        }
        return repoName;
    }

    private HttpResponse serveUserRepo(ServiceRequestContext ctx, HttpRequest req, User user, String projectName, String repoName) throws Exception {
        CompletableFuture<RepositoryRole> f;
        try {
            f = this.mds.findRepositoryRole(projectName, repoName, user);
        }
        catch (Throwable cause2) {
            return RequiresProjectRoleDecorator.handleException(ctx, cause2);
        }
        return HttpResponse.of(f.handle((role, cause) -> {
            if (cause != null) {
                return RequiresProjectRoleDecorator.handleException(ctx, cause);
            }
            if (role == null || !role.has(this.requiredRole)) {
                return (HttpResponse)HttpApiUtil.throwResponse(ctx, HttpStatus.FORBIDDEN, "You must have the %s repository role to access the '%s/%s'.", this.requiredRole, projectName, repoName);
            }
            try {
                return (HttpResponse)((Service)this.unwrap()).serve(ctx, (Request)req);
            }
            catch (Exception e) {
                return (HttpResponse)Exceptions.throwUnsafely((Throwable)e);
            }
        }));
    }

    public static final class RequiresRepositoryRoleDecoratorFactory
    implements DecoratorFactoryFunction<RequiresRepositoryRole> {
        private final MetadataService mds;

        public RequiresRepositoryRoleDecoratorFactory(MetadataService mds) {
            this.mds = Objects.requireNonNull(mds, "mds");
        }

        public Function<? super HttpService, ? extends HttpService> newDecorator(RequiresRepositoryRole parameter) {
            return delegate -> new RequiresRepositoryRoleDecorator((HttpService)delegate, this.mds, parameter.value(), Strings.emptyToNull((String)parameter.project()), Strings.emptyToNull((String)parameter.repository()));
        }
    }
}

