/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.api;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.server.annotation.ConsumesJson;
import com.linecorp.armeria.server.annotation.Get;
import com.linecorp.armeria.server.annotation.Param;
import com.linecorp.armeria.server.annotation.ProducesJson;
import com.linecorp.armeria.server.annotation.Put;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.centraldogma.server.internal.api.auth.RequiresSystemAdministrator;
import java.util.List;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequiresSystemAdministrator
@ProducesJson
public class LoggerService {
    private static final Logger logger = LoggerFactory.getLogger(LoggerService.class);
    private static final List<String> LEVELS = ImmutableList.of((Object)"ALL", (Object)"TRACE", (Object)"DEBUG", (Object)"INFO", (Object)"WARN", (Object)"ERROR", (Object)"OFF");
    private final LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();

    @Put(value="/loggers/{logger}")
    @ConsumesJson
    public HttpResponse setLogLevel(@Param(value="logger") String loggerName, JsonNode jsonNode) {
        ch.qos.logback.classic.Logger logger = this.loggerContext.exists(loggerName);
        if (logger == null) {
            return HttpResponse.of((HttpStatus)HttpStatus.NOT_FOUND, (MediaType)MediaType.PLAIN_TEXT_UTF_8, (String)("Logger not found: " + loggerName));
        }
        JsonNode levelNode = jsonNode.get("level");
        if (levelNode == null) {
            return HttpResponse.of((HttpStatus)HttpStatus.BAD_REQUEST, (MediaType)MediaType.PLAIN_TEXT_UTF_8, (String)"Missing 'level' field in request body.");
        }
        if (levelNode.isNull()) {
            logger.setLevel(null);
            LoggerService.logger.info("Set log level of '{}' to null. effectiveLevel='{}'", (Object)loggerName, (Object)logger.getEffectiveLevel());
            return HttpResponse.ofJson((Object)LoggerInfo.of(logger));
        }
        if (!levelNode.isTextual()) {
            return HttpResponse.of((HttpStatus)HttpStatus.BAD_REQUEST, (MediaType)MediaType.PLAIN_TEXT_UTF_8, (String)("'level' field must be a string. Found: " + String.valueOf(levelNode.getNodeType())));
        }
        String level = levelNode.asText();
        String upperCase = level.toUpperCase();
        if (!LEVELS.contains(upperCase)) {
            return HttpResponse.of((HttpStatus)HttpStatus.BAD_REQUEST, (MediaType)MediaType.PLAIN_TEXT_UTF_8, (String)("Invalid log level: " + level + ". Valid levels are: " + String.valueOf(LEVELS)));
        }
        logger.setLevel(Level.toLevel((String)upperCase));
        LoggerService.logger.info("Set log level of '{}' to '{}'.", (Object)loggerName, (Object)upperCase);
        return HttpResponse.ofJson((Object)LoggerInfo.of(logger));
    }

    @Get(value="/loggers/{logger}")
    public HttpResponse getLogLevel(@Param(value="logger") String loggerName) {
        ch.qos.logback.classic.Logger logger = this.loggerContext.exists(loggerName);
        if (logger == null) {
            return HttpResponse.of((HttpStatus)HttpStatus.NOT_FOUND, (MediaType)MediaType.PLAIN_TEXT_UTF_8, (String)("Logger not found: " + loggerName));
        }
        return HttpResponse.ofJson((Object)LoggerInfo.of(logger));
    }

    @Get(value="/loggers")
    @ProducesJson
    public HttpResponse getLogLevels() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ch.qos.logback.classic.Logger logger : this.loggerContext.getLoggerList()) {
            builder.add((Object)LoggerInfo.of(logger));
        }
        return HttpResponse.ofJson((Object)builder.build());
    }

    private static final class LoggerInfo {
        private final String name;
        @Nullable
        private final String level;
        private final String effectiveLevel;

        static LoggerInfo of(ch.qos.logback.classic.Logger logger) {
            return new LoggerInfo(logger.getName(), logger.getLevel() != null ? logger.getLevel().toString() : null, logger.getEffectiveLevel().toString());
        }

        LoggerInfo(String name, @Nullable String level, String effectiveLevel) {
            this.name = name;
            this.level = level;
            this.effectiveLevel = effectiveLevel;
        }

        @JsonProperty(value="name")
        String name() {
            return this.name;
        }

        @Nullable
        @JsonProperty(value="level")
        String level() {
            return this.level;
        }

        @JsonProperty(value="effectiveLevel")
        String effectiveLevel() {
            return this.effectiveLevel;
        }
    }
}

