/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.admin.service;

import com.linecorp.armeria.common.Cookie;
import com.linecorp.armeria.common.CookieBuilder;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.ResponseHeaders;
import com.linecorp.armeria.common.util.UnmodifiableFuture;
import com.linecorp.armeria.server.AbstractHttpService;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.centraldogma.server.auth.SessionManager;
import com.linecorp.centraldogma.server.internal.admin.auth.SessionCookieHandler;
import com.linecorp.centraldogma.server.internal.admin.auth.SessionUtil;
import com.linecorp.centraldogma.server.storage.encryption.EncryptionStorageManager;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.BooleanSupplier;
import java.util.function.Function;

public class DefaultLogoutService
extends AbstractHttpService {
    private final Function<String, CompletableFuture<Void>> logoutSessionPropagator;
    private final SessionManager sessionManager;
    private final SessionCookieHandler sessionCookieHandler;
    private final Cookie invalidatingCookie;

    public DefaultLogoutService(Function<String, CompletableFuture<Void>> logoutSessionPropagator, BooleanSupplier sessionPropagatorWritableChecker, SessionManager sessionManager, boolean tlsEnabled, EncryptionStorageManager encryptionStorageManager) {
        this.logoutSessionPropagator = Objects.requireNonNull(logoutSessionPropagator, "logoutSessionPropagator");
        this.sessionManager = Objects.requireNonNull(sessionManager, "sessionManager");
        this.sessionCookieHandler = new SessionCookieHandler(sessionPropagatorWritableChecker, tlsEnabled, encryptionStorageManager);
        Objects.requireNonNull(encryptionStorageManager, "encryptionStorageManager");
        String sessionCookieName = SessionUtil.sessionCookieName(tlsEnabled, encryptionStorageManager.encryptSessionCookie());
        CookieBuilder cookieBuilder = Cookie.secureBuilder((String)sessionCookieName, (String)"").maxAge(0L).path("/");
        if (!tlsEnabled) {
            cookieBuilder.secure(false);
        }
        this.invalidatingCookie = cookieBuilder.build();
    }

    protected HttpResponse doPost(ServiceRequestContext ctx, HttpRequest req) throws Exception {
        return HttpResponse.of((CompletableFuture)this.sessionCookieHandler.getSessionInfo(ctx).thenCompose(sessionInfo -> {
            if (sessionInfo == null) {
                return UnmodifiableFuture.completedFuture((Object)HttpResponse.of((HttpStatus)HttpStatus.NO_CONTENT));
            }
            String sessionId = sessionInfo.sessionId();
            if (sessionId == null) {
                String username = sessionInfo.username();
                String csrfTokenFromSignedJwt = sessionInfo.csrfTokenFromSignedJwt();
                if (username == null || csrfTokenFromSignedJwt == null) {
                    return UnmodifiableFuture.completedFuture((Object)HttpResponse.of((HttpStatus)HttpStatus.UNAUTHORIZED, (MediaType)MediaType.PLAIN_TEXT_UTF_8, (String)"Invalid session"));
                }
                if (!SessionUtil.validateCsrfToken(ctx, req, csrfTokenFromSignedJwt)) {
                    return UnmodifiableFuture.completedFuture((Object)DefaultLogoutService.invalidCsrfTokenResponse());
                }
                return UnmodifiableFuture.completedFuture((Object)HttpResponse.of((ResponseHeaders)ResponseHeaders.builder((HttpStatus)HttpStatus.OK).cookie(this.invalidatingCookie).build()));
            }
            return this.sessionManager.get(sessionId).thenCompose(session -> {
                if (session == null) {
                    return UnmodifiableFuture.completedFuture((Object)HttpResponse.of((HttpStatus)HttpStatus.NO_CONTENT));
                }
                if (!SessionUtil.validateCsrfToken(ctx, req, session.csrfToken())) {
                    return UnmodifiableFuture.completedFuture((Object)DefaultLogoutService.invalidCsrfTokenResponse());
                }
                return this.invalidateSession(ctx, sessionId).thenCompose(unused -> this.logoutSessionPropagator.apply(sessionId).thenApply(unused2 -> HttpResponse.of((ResponseHeaders)ResponseHeaders.builder((HttpStatus)HttpStatus.OK).cookie(this.invalidatingCookie).build())));
            });
        }));
    }

    private static HttpResponse invalidCsrfTokenResponse() {
        return HttpResponse.of((HttpStatus)HttpStatus.FORBIDDEN, (MediaType)MediaType.PLAIN_TEXT_UTF_8, (String)"Invalid CSRF token");
    }

    protected CompletableFuture<Void> invalidateSession(ServiceRequestContext ctx, String sessionId) {
        return UnmodifiableFuture.completedFuture(null);
    }
}

