/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.admin.auth;

import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.util.UnmodifiableFuture;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.auth.AuthorizationStatus;
import com.linecorp.armeria.server.auth.Authorizer;
import com.linecorp.centraldogma.server.auth.SessionManager;
import com.linecorp.centraldogma.server.internal.admin.auth.AuthUtil;
import com.linecorp.centraldogma.server.internal.admin.auth.SessionCookieHandler;
import com.linecorp.centraldogma.server.internal.admin.auth.SessionUtil;
import com.linecorp.centraldogma.server.internal.api.HttpApiUtil;
import com.linecorp.centraldogma.server.metadata.User;
import com.linecorp.centraldogma.server.storage.encryption.EncryptionStorageManager;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionCookieAuthorizer
implements Authorizer<HttpRequest> {
    private static final Logger logger = LoggerFactory.getLogger(SessionCookieAuthorizer.class);
    private final SessionManager sessionManager;
    private final Set<String> systemAdministrators;
    private final SessionCookieHandler sessionCookieHandler;

    public SessionCookieAuthorizer(SessionManager sessionManager, BooleanSupplier sessionPropagatorWritableChecker, boolean tlsEnabled, EncryptionStorageManager encryptionStorageManager, Set<String> systemAdministrators) {
        this.sessionManager = Objects.requireNonNull(sessionManager, "sessionManager");
        Objects.requireNonNull(encryptionStorageManager, "encryptionStorageManager");
        this.sessionCookieHandler = new SessionCookieHandler(sessionPropagatorWritableChecker, tlsEnabled, encryptionStorageManager);
        this.systemAdministrators = Objects.requireNonNull(systemAdministrators, "systemAdministrators");
    }

    public CompletionStage<Boolean> authorize(ServiceRequestContext ctx, HttpRequest req) {
        throw new UnsupportedOperationException();
    }

    public CompletionStage<AuthorizationStatus> authorizeAndSupplyHandlers(ServiceRequestContext ctx, @Nullable HttpRequest req) {
        if (req == null) {
            return UnmodifiableFuture.completedFuture((Object)AuthorizationStatus.of((boolean)false));
        }
        return this.sessionCookieHandler.getSessionInfo(ctx).thenCompose(sessionInfo -> {
            if (sessionInfo == null) {
                return UnmodifiableFuture.completedFuture((Object)AuthorizationStatus.of((boolean)false));
            }
            String sessionId = sessionInfo.sessionId();
            if (sessionId == null) {
                String username = sessionInfo.username();
                String csrfTokenFromSignedJwt = sessionInfo.csrfTokenFromSignedJwt();
                assert (username != null);
                assert (csrfTokenFromSignedJwt != null);
                if (!SessionUtil.validateCsrfToken(ctx, req, csrfTokenFromSignedJwt)) {
                    return UnmodifiableFuture.completedFuture((Object)SessionCookieAuthorizer.invalidCsrfToken());
                }
                this.setCurrentUser(ctx, username);
                return UnmodifiableFuture.completedFuture((Object)AuthorizationStatus.of((boolean)true));
            }
            return this.sessionManager.get(sessionId).thenApply(session -> {
                if (session == null) {
                    logger.trace("Session not found (or expired), ctx={}", (Object)ctx);
                    return AuthorizationStatus.of((boolean)false);
                }
                if (!SessionUtil.validateCsrfToken(ctx, req, session.csrfToken())) {
                    return SessionCookieAuthorizer.invalidCsrfToken();
                }
                this.setCurrentUser(ctx, session.username());
                return AuthorizationStatus.of((boolean)true);
            });
        });
    }

    private static AuthorizationStatus invalidCsrfToken() {
        return AuthorizationStatus.ofFailure((delegate, ctx1, req1, cause) -> HttpResponse.of((HttpStatus)HttpStatus.FORBIDDEN, (MediaType)MediaType.PLAIN_TEXT_UTF_8, (String)"Invalid CSRF token"));
    }

    private void setCurrentUser(ServiceRequestContext ctx, String username) {
        List<String> roles = this.systemAdministrators.contains(username) ? User.LEVEL_SYSTEM_ADMIN : User.LEVEL_USER;
        User user = new User(username, roles);
        ctx.logBuilder().authenticatedUser("user/" + username);
        AuthUtil.setCurrentUser(ctx, user);
        HttpApiUtil.setVerboseResponses(ctx, user);
    }
}

