/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.admin.auth;

import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.centraldogma.common.Author;
import com.linecorp.centraldogma.internal.shaded.guava.annotations.VisibleForTesting;
import com.linecorp.centraldogma.server.metadata.User;
import io.netty.util.AttributeKey;
import java.util.Objects;
import javax.annotation.Nullable;

public final class AuthUtil {
    @VisibleForTesting
    public static final AttributeKey<User> CURRENT_USER = AttributeKey.valueOf(AuthUtil.class, (String)"CURRENT_USER");

    public static Author currentAuthor(ServiceRequestContext ctx) {
        User user = (User)ctx.attr(CURRENT_USER);
        assert (user != null);
        return AuthUtil.getAuthor(user);
    }

    public static Author currentAuthor() {
        return AuthUtil.currentAuthor((ServiceRequestContext)RequestContext.current());
    }

    public static Author getAuthor(User user) {
        if (user == User.DEFAULT) {
            return Author.DEFAULT;
        }
        if (user == User.SYSTEM) {
            return Author.SYSTEM;
        }
        return new Author(user.name(), user.email());
    }

    public static User currentUser(ServiceRequestContext ctx) {
        return (User)ctx.attr(CURRENT_USER);
    }

    public static User currentUser() {
        return AuthUtil.currentUser((ServiceRequestContext)RequestContext.current());
    }

    @Nullable
    public static User currentUserOrNull() {
        ServiceRequestContext currentOrNull = ServiceRequestContext.currentOrNull();
        if (currentOrNull == null) {
            return null;
        }
        return AuthUtil.currentUser(currentOrNull);
    }

    public static void setCurrentUser(ServiceRequestContext ctx, User currentUser) {
        Objects.requireNonNull(ctx, "ctx");
        Objects.requireNonNull(currentUser, "currentUser");
        ctx.setAttr(CURRENT_USER, (Object)currentUser);
    }

    private AuthUtil() {
    }
}

