/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.admin.auth;

import com.linecorp.centraldogma.common.ReadOnlyException;
import com.linecorp.centraldogma.internal.shaded.futures.CompletableFutures;
import com.linecorp.centraldogma.server.auth.Session;
import com.linecorp.centraldogma.server.auth.SessionKey;
import com.linecorp.centraldogma.server.internal.admin.auth.SessionUtil;
import com.linecorp.centraldogma.server.storage.encryption.EncryptionStorageManager;
import com.nimbusds.jwt.SignedJWT;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public final class AuthSessionService {
    private final Function<Session, CompletableFuture<Void>> loginSessionPropagator;
    private final BooleanSupplier sessionPropagatorWritableChecker;
    private final Duration sessionValidDuration;
    private final boolean encryptSessionCookie;
    @Nullable
    private volatile SessionKey sessionKey;

    public AuthSessionService(Function<Session, CompletableFuture<Void>> loginSessionPropagator, BooleanSupplier sessionPropagatorWritableChecker, Duration sessionValidDuration, EncryptionStorageManager encryptionStorageManager) {
        this.loginSessionPropagator = Objects.requireNonNull(loginSessionPropagator, "loginSessionPropagator");
        this.sessionPropagatorWritableChecker = Objects.requireNonNull(sessionPropagatorWritableChecker, "sessionPropagatorWritableChecker");
        this.sessionValidDuration = Objects.requireNonNull(sessionValidDuration, "sessionValidDuration");
        Objects.requireNonNull(encryptionStorageManager, "encryptionStorageManager");
        this.encryptSessionCookie = encryptionStorageManager.encryptSessionCookie();
        if (this.encryptSessionCookie) {
            this.sessionKey = encryptionStorageManager.getCurrentSessionKey().join();
            encryptionStorageManager.addSessionKeyListener(sessionKey -> {
                this.sessionKey = sessionKey;
            });
        } else {
            this.sessionKey = null;
        }
    }

    public CompletableFuture<LoginResult> create(String username, Supplier<String> sessionIdGenerator, Supplier<String> csrfTokenGenerator) {
        if (!this.sessionPropagatorWritableChecker.getAsBoolean()) {
            if (!this.encryptSessionCookie) {
                return CompletableFutures.exceptionallyCompletedFuture((Throwable)new ReadOnlyException("Cannot login in read-only mode without session encryption"));
            }
            SessionKey sessionKey = this.sessionKey;
            assert (sessionKey != null);
            String sessionKeyVersion = Integer.toString(sessionKey.version());
            SignedJWT signedJwt = SessionUtil.createSignedJwtInReadOnly(username, sessionKeyVersion, sessionKey.signer());
            String csrfToken = SessionUtil.csrfTokenFromSignedJwt(signedJwt);
            String sessionCookieValue = SessionUtil.createJwe(signedJwt.serialize(), sessionKeyVersion, sessionKey.encrypter());
            return CompletableFuture.completedFuture(new LoginResult(sessionCookieValue, csrfToken));
        }
        String sessionId = sessionIdGenerator.get();
        String csrfToken = csrfTokenGenerator.get();
        Session newSession = new Session(sessionId, csrfToken, username, this.sessionValidDuration);
        return this.loginSessionPropagator.apply(newSession).thenApply(unused -> {
            String sessionCookieValue;
            if (this.encryptSessionCookie) {
                SessionKey sessionKey = this.sessionKey;
                assert (sessionKey != null);
                sessionCookieValue = SessionUtil.createSessionJwe(newSession, Integer.toString(sessionKey.version()), sessionKey.signer(), sessionKey.encrypter());
            } else {
                sessionCookieValue = sessionId;
            }
            return new LoginResult(sessionCookieValue, csrfToken);
        });
    }

    public static final class LoginResult {
        private final String sessionCookieValue;
        private final String csrfToken;

        LoginResult(String sessionCookieValue, String csrfToken) {
            this.sessionCookieValue = sessionCookieValue;
            this.csrfToken = csrfToken;
        }

        public String sessionCookieValue() {
            return this.sessionCookieValue;
        }

        public String csrfToken() {
            return this.csrfToken;
        }
    }
}

