/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.command;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.linecorp.centraldogma.common.Author;
import com.linecorp.centraldogma.internal.shaded.guava.base.MoreObjects;
import com.linecorp.centraldogma.internal.shaded.guava.base.Preconditions;
import com.linecorp.centraldogma.server.command.CommandType;
import com.linecorp.centraldogma.server.command.RootCommand;
import com.linecorp.centraldogma.server.storage.encryption.WrappedDekDetails;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public final class CreateProjectCommand
extends RootCommand<Void> {
    private final String projectName;
    @Nullable
    private final WrappedDekDetails wdekDetails;

    @JsonCreator
    CreateProjectCommand(@JsonProperty(value="timestamp") @Nullable Long timestamp, @JsonProperty(value="author") @Nullable Author author, @JsonProperty(value="projectName") String projectName, @JsonProperty(value="wdekDetails") @Nullable WrappedDekDetails wdekDetails) {
        super(CommandType.CREATE_PROJECT, timestamp, author);
        this.projectName = Objects.requireNonNull(projectName, "projectName");
        this.wdekDetails = wdekDetails;
        if (wdekDetails != null) {
            Preconditions.checkArgument((boolean)wdekDetails.projectName().equals(projectName), (String)"projectName: %s, (expected: %s", (Object)projectName, (Object)wdekDetails.projectName());
        }
    }

    @JsonProperty
    public String projectName() {
        return this.projectName;
    }

    @Nullable
    @JsonProperty
    public WrappedDekDetails wdekDetails() {
        return this.wdekDetails;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CreateProjectCommand)) {
            return false;
        }
        CreateProjectCommand that = (CreateProjectCommand)obj;
        return super.equals(obj) && this.projectName.equals(that.projectName) && Objects.equals(this.wdekDetails, that.wdekDetails);
    }

    @Override
    public int hashCode() {
        return (this.projectName.hashCode() * 31 + Objects.hashCode(this.wdekDetails)) * 31 + super.hashCode();
    }

    @Override
    MoreObjects.ToStringHelper toStringHelper() {
        return super.toStringHelper().omitNullValues().add("projectName", (Object)this.projectName).add("wdekDetails", (Object)this.wdekDetails);
    }
}

