/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.auth;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.linecorp.centraldogma.internal.shaded.guava.base.MoreObjects;
import com.linecorp.centraldogma.internal.shaded.guava.base.Preconditions;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Objects;

public final class SessionMasterKey {
    private final String wrappedMasterKey;
    private final int version;
    private final String salt;
    private final String kekId;
    private final String creation;
    private final Instant creationInstant;

    @JsonCreator
    public SessionMasterKey(@JsonProperty(value="wrappedMasterKey") String wrappedMasterKey, @JsonProperty(value="version") int version, @JsonProperty(value="salt") String salt, @JsonProperty(value="kekId") String kekId, @JsonProperty(value="creation") Instant creationInstant) {
        this.wrappedMasterKey = Objects.requireNonNull(wrappedMasterKey, "wrappedMasterKey");
        Preconditions.checkArgument((version > 0 ? 1 : 0) != 0, (String)"version must be positive: %s", (int)version);
        this.version = version;
        this.salt = Objects.requireNonNull(salt, "salt");
        this.kekId = Objects.requireNonNull(kekId, "kekId");
        this.creationInstant = creationInstant;
        this.creation = DateTimeFormatter.ISO_INSTANT.format(Objects.requireNonNull(creationInstant, "creation"));
    }

    @JsonProperty
    public String wrappedMasterKey() {
        return this.wrappedMasterKey;
    }

    @JsonProperty
    public int version() {
        return this.version;
    }

    @JsonProperty
    public String salt() {
        return this.salt;
    }

    @JsonProperty
    public String kekId() {
        return this.kekId;
    }

    @JsonProperty
    public String creation() {
        return this.creation;
    }

    public Instant creationInstant() {
        return this.creationInstant;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("wrappedMasterKey", (Object)"****").add("version", this.version).add("salt", (Object)"****").add("kekId", (Object)this.kekId).add("creation", (Object)this.creation).toString();
    }
}

