/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server;

import com.linecorp.armeria.common.util.StartStopSupport;
import com.linecorp.centraldogma.internal.shaded.futures.CompletableFutures;
import com.linecorp.centraldogma.internal.shaded.guava.annotations.VisibleForTesting;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableMap;
import com.linecorp.centraldogma.internal.shaded.guava.collect.Iterables;
import com.linecorp.centraldogma.server.CentralDogmaConfig;
import com.linecorp.centraldogma.server.command.CommandExecutor;
import com.linecorp.centraldogma.server.mirror.MirrorAccessController;
import com.linecorp.centraldogma.server.plugin.Plugin;
import com.linecorp.centraldogma.server.plugin.PluginContext;
import com.linecorp.centraldogma.server.plugin.PluginTarget;
import com.linecorp.centraldogma.server.storage.project.InternalProjectInitializer;
import com.linecorp.centraldogma.server.storage.project.ProjectManager;
import io.micrometer.core.instrument.MeterRegistry;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class PluginGroup {
    private static final Logger logger = LoggerFactory.getLogger(PluginGroup.class);
    private final List<Plugin> plugins;
    private final PluginGroupStartStop startStop;

    @Nullable
    @VisibleForTesting
    static PluginGroup loadPlugins(PluginTarget target, CentralDogmaConfig config) {
        return PluginGroup.loadPlugins(PluginGroup.class.getClassLoader(), config, (List<Plugin>)ImmutableList.of()).get((Object)target);
    }

    static Map<PluginTarget, PluginGroup> loadPlugins(ClassLoader classLoader, CentralDogmaConfig config, List<Plugin> plugins) {
        Objects.requireNonNull(classLoader, "classLoader");
        Objects.requireNonNull(config, "config");
        ServiceLoader<Plugin> loader = ServiceLoader.load(Plugin.class, classLoader);
        ImmutableMap.Builder allPlugins = new ImmutableMap.Builder();
        for (Plugin plugin2 : Iterables.concat(plugins, loader)) {
            if (!plugin2.isEnabled(config)) continue;
            allPlugins.put(plugin2.configType(), (Object)plugin2);
        }
        ImmutableMap pluginMap = allPlugins.build();
        if (pluginMap.isEmpty()) {
            return ImmutableMap.of();
        }
        Map pluginGroups = (Map)pluginMap.values().stream().collect(Collectors.groupingBy(plugin -> plugin.target(config))).entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, e -> {
            PluginTarget target = (PluginTarget)((Object)((Object)e.getKey()));
            List targetPlugins = (List)e.getValue();
            String poolName = "plugins-for-" + target.name().toLowerCase().replace("_", "-");
            return new PluginGroup(targetPlugins, Executors.newSingleThreadExecutor((ThreadFactory)new DefaultThreadFactory(poolName, true)));
        }));
        pluginGroups.forEach((target, group) -> logger.debug("Loaded plugins for target {}: {}", (Object)target, group.plugins().stream().map(plugin -> plugin.getClass().getName()).collect(ImmutableList.toImmutableList())));
        return pluginGroups;
    }

    private PluginGroup(Iterable<Plugin> plugins, Executor executor) {
        this.plugins = ImmutableList.copyOf(Objects.requireNonNull(plugins, "plugins"));
        this.startStop = new PluginGroupStartStop(Objects.requireNonNull(executor, "executor"));
    }

    List<Plugin> plugins() {
        return this.plugins;
    }

    @Nullable
    <T extends Plugin> T findFirstPlugin(Class<T> clazz) {
        Objects.requireNonNull(clazz, "clazz");
        return (T)((Plugin)this.plugins.stream().filter(clazz::isInstance).map(clazz::cast).findFirst().orElse(null));
    }

    CompletableFuture<Void> start(CentralDogmaConfig config, ProjectManager projectManager, CommandExecutor commandExecutor, MeterRegistry meterRegistry, ScheduledExecutorService purgeWorker, InternalProjectInitializer internalProjectInitializer, MirrorAccessController mirrorAccessController) {
        PluginContext context = new PluginContext(config, projectManager, commandExecutor, meterRegistry, purgeWorker, internalProjectInitializer, mirrorAccessController);
        return this.startStop.start(context, context, true);
    }

    CompletableFuture<Void> stop(CentralDogmaConfig config, ProjectManager projectManager, CommandExecutor commandExecutor, MeterRegistry meterRegistry, ScheduledExecutorService purgeWorker, InternalProjectInitializer internalProjectInitializer, MirrorAccessController mirrorAccessController) {
        return this.startStop.stop(new PluginContext(config, projectManager, commandExecutor, meterRegistry, purgeWorker, internalProjectInitializer, mirrorAccessController));
    }

    private class PluginGroupStartStop
    extends StartStopSupport<PluginContext, PluginContext, Void, Void> {
        PluginGroupStartStop(Executor executor) {
            super(executor);
        }

        protected CompletionStage<Void> doStart(@Nullable PluginContext arg) throws Exception {
            assert (arg != null);
            arg.internalProjectInitializer().whenInitialized().get();
            List futures = (List)PluginGroup.this.plugins.stream().map(plugin -> {
                logger.info("Starting plugin: {}", plugin);
                long start = System.nanoTime();
                return plugin.start(arg).thenAccept(unused -> logger.info("Plugin started: {} in {} seconds", plugin, (Object)Duration.ofNanos(System.nanoTime() - start).getSeconds())).exceptionally(cause -> {
                    logger.info("Failed to start plugin: {}", plugin, cause);
                    return null;
                });
            }).collect(ImmutableList.toImmutableList());
            return CompletableFutures.allAsList((List)futures).thenApply(unused -> null);
        }

        protected CompletionStage<Void> doStop(@Nullable PluginContext arg) throws Exception {
            assert (arg != null);
            List futures = (List)PluginGroup.this.plugins.stream().map(plugin -> {
                logger.info("Stopping plugin: {}", plugin);
                long start = System.nanoTime();
                return plugin.stop(arg).thenAccept(unused -> logger.info("Stopped plugin: {} in {} seconds.", plugin, (Object)Duration.ofNanos(System.nanoTime() - start).getSeconds())).exceptionally(cause -> {
                    logger.info("Failed to stop plugin: {}", plugin, cause);
                    return null;
                });
            }).collect(ImmutableList.toImmutableList());
            return CompletableFutures.allAsList((List)futures).thenApply(unused -> null);
        }
    }
}

