/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.storage.repository;

import com.fasterxml.jackson.databind.JsonNode;
import com.linecorp.centraldogma.common.Author;
import com.linecorp.centraldogma.common.CentralDogmaException;
import com.linecorp.centraldogma.common.Change;
import com.linecorp.centraldogma.common.Commit;
import com.linecorp.centraldogma.common.Entry;
import com.linecorp.centraldogma.common.EntryNotFoundException;
import com.linecorp.centraldogma.common.EntryType;
import com.linecorp.centraldogma.common.Markup;
import com.linecorp.centraldogma.common.MergeQuery;
import com.linecorp.centraldogma.common.MergedEntry;
import com.linecorp.centraldogma.common.Query;
import com.linecorp.centraldogma.common.QueryExecutionException;
import com.linecorp.centraldogma.common.Revision;
import com.linecorp.centraldogma.common.RevisionRange;
import com.linecorp.centraldogma.internal.Util;
import com.linecorp.centraldogma.internal.shaded.futures.CompletableFutures;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableMap;
import com.linecorp.centraldogma.server.command.CommitResult;
import com.linecorp.centraldogma.server.command.ContentTransformer;
import com.linecorp.centraldogma.server.storage.project.Project;
import com.linecorp.centraldogma.server.storage.repository.CacheableCall;
import com.linecorp.centraldogma.server.storage.repository.DiffResultType;
import com.linecorp.centraldogma.server.storage.repository.FindOption;
import com.linecorp.centraldogma.server.storage.repository.FindOptions;
import com.linecorp.centraldogma.server.storage.repository.RepositoryListener;
import com.linecorp.centraldogma.server.storage.repository.RepositoryUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

public interface Repository {
    public static final int DEFAULT_MAX_COMMITS = 100;
    public static final int MAX_MAX_COMMITS = 1000;
    public static final String ALL_PATH = "/**";

    public org.eclipse.jgit.lib.Repository jGitRepository();

    public Project parent();

    public File repoDir();

    public String name();

    public long creationTimeMillis();

    public Author author();

    @Deprecated
    default public CompletableFuture<Revision> normalize(Revision revision) {
        try {
            return CompletableFuture.completedFuture(this.normalizeNow(revision));
        }
        catch (Exception e) {
            return CompletableFutures.exceptionallyCompletedFuture((Throwable)e);
        }
    }

    public Revision normalizeNow(Revision var1);

    public RevisionRange normalizeNow(Revision var1, Revision var2);

    default public CompletableFuture<Boolean> exists(Revision revision, String path) {
        Util.validateFilePath((String)path, (String)"path");
        return this.find(revision, path, FindOptions.FIND_ONE_WITHOUT_CONTENT).thenApply(result -> !result.isEmpty());
    }

    default public CompletableFuture<Entry<?>> get(Revision revision, String path) {
        return this.getOrNull(revision, path).thenApply(entry -> {
            if (entry == null) {
                throw new EntryNotFoundException(revision, path);
            }
            return entry;
        });
    }

    default public <T> CompletableFuture<Entry<T>> get(Revision revision, Query<T> query) {
        return this.getOrNull(revision, query).thenApply(res -> {
            if (res == null) {
                throw new EntryNotFoundException(revision, query.path());
            }
            return res;
        });
    }

    default public CompletableFuture<Entry<?>> getOrNull(Revision revision, String path) {
        Util.validateFilePath((String)path, (String)"path");
        return this.find(revision, path, FindOptions.FIND_ONE_WITH_CONTENT).thenApply(findResult -> (Entry)findResult.get(path));
    }

    default public <T> CompletableFuture<Entry<T>> getOrNull(Revision revision, Query<T> query) {
        Objects.requireNonNull(query, "query");
        Objects.requireNonNull(revision, "revision");
        return this.getOrNull(revision, query.path()).thenApply(result -> {
            if (result == null) {
                return null;
            }
            Entry entry = result;
            try {
                return RepositoryUtil.applyQuery(entry, query);
            }
            catch (CentralDogmaException e) {
                throw e;
            }
            catch (Exception e) {
                throw new QueryExecutionException((Throwable)e);
            }
        });
    }

    default public CompletableFuture<Map<String, Entry<?>>> find(Revision revision, String pathPattern) {
        return this.find(revision, pathPattern, (Map<FindOption<?>, ?>)ImmutableMap.of());
    }

    public CompletableFuture<Map<String, Entry<?>>> find(Revision var1, String var2, Map<FindOption<?>, ?> var3);

    default public CompletableFuture<Change<?>> diff(Revision from, Revision to, Query<?> query) {
        return this.diff(from, to, query, DiffResultType.NORMAL);
    }

    default public CompletableFuture<Change<?>> diff(Revision from, Revision to, Query<?> query, DiffResultType diffResultType) {
        RevisionRange range;
        Objects.requireNonNull(from, "from");
        Objects.requireNonNull(to, "to");
        Objects.requireNonNull(query, "query");
        Objects.requireNonNull(diffResultType, "diffResultType");
        try {
            range = this.normalizeNow(from, to).toAscending();
        }
        catch (Exception e) {
            return CompletableFutures.exceptionallyCompletedFuture((Throwable)e);
        }
        String path = query.path();
        CompletableFuture<Entry<?>> fromEntryFuture = this.getOrNull(range.from(), path);
        CompletableFuture<Entry<?>> toEntryFuture = this.getOrNull(range.to(), path);
        CompletableFuture future = CompletableFutures.combine(fromEntryFuture, toEntryFuture, (fromEntry, toEntry) -> {
            Query castQuery = query;
            if (fromEntry != null) {
                if (toEntry == null) {
                    return Change.ofRemoval((String)path);
                }
            } else {
                if (toEntry != null) {
                    EntryType toEntryType = toEntry.type();
                    if (!query.type().supportedEntryTypes().contains(toEntryType)) {
                        throw new QueryExecutionException("unsupported entry type: " + String.valueOf(toEntryType));
                    }
                    Object toContent = castQuery.apply(toEntry.content());
                    switch (toEntryType) {
                        case JSON: {
                            return Change.ofJsonUpsert((String)path, (JsonNode)((JsonNode)toContent));
                        }
                        case TEXT: {
                            return Change.ofTextUpsert((String)path, (String)((String)toContent));
                        }
                    }
                    throw new Error();
                }
                throw new EntryNotFoundException(path + " (" + String.valueOf(from) + ", " + String.valueOf(to) + ")");
            }
            EntryType entryType = fromEntry.type();
            if (!query.type().supportedEntryTypes().contains(entryType)) {
                throw new QueryExecutionException("unsupported entry type: " + String.valueOf(entryType));
            }
            if (entryType != toEntry.type()) {
                throw new QueryExecutionException("mismatching entry type: " + String.valueOf(entryType) + " != " + String.valueOf(toEntry.type()));
            }
            Object fromContent = castQuery.apply(fromEntry.content());
            Object toContent = castQuery.apply(toEntry.content());
            switch (entryType) {
                case JSON: {
                    if (diffResultType == DiffResultType.PATCH_TO_UPSERT) {
                        return Change.ofJsonUpsert((String)path, (JsonNode)((JsonNode)toContent));
                    }
                    return Change.ofJsonPatch((String)path, (JsonNode)((JsonNode)fromContent), (JsonNode)((JsonNode)toContent));
                }
                case TEXT: {
                    if (diffResultType == DiffResultType.PATCH_TO_UPSERT) {
                        return Change.ofTextUpsert((String)path, (String)((String)toContent));
                    }
                    return Change.ofTextPatch((String)path, (String)((String)fromContent), (String)((String)toContent));
                }
            }
            throw new Error();
        }).toCompletableFuture();
        return (CompletableFuture)Util.unsafeCast(future);
    }

    default public CompletableFuture<Map<String, Change<?>>> diff(Revision from, Revision to, String pathPattern) {
        return this.diff(from, to, pathPattern, DiffResultType.NORMAL);
    }

    public CompletableFuture<Map<String, Change<?>>> diff(Revision var1, Revision var2, String var3, DiffResultType var4);

    default public CompletableFuture<Map<String, Change<?>>> previewDiff(Revision baseRevision, Change<?> ... changes) {
        Objects.requireNonNull(changes, "changes");
        return this.previewDiff(baseRevision, Arrays.asList(changes));
    }

    public CompletableFuture<Map<String, Change<?>>> previewDiff(Revision var1, Iterable<Change<?>> var2);

    default public CompletableFuture<CommitResult> commit(Revision baseRevision, long commitTimeMillis, Author author, String summary, Iterable<Change<?>> changes) {
        return this.commit(baseRevision, commitTimeMillis, author, summary, "", Markup.PLAINTEXT, changes, true);
    }

    default public CompletableFuture<CommitResult> commit(Revision baseRevision, long commitTimeMillis, Author author, String summary, Change<?> ... changes) {
        return this.commit(baseRevision, commitTimeMillis, author, summary, "", Markup.PLAINTEXT, changes);
    }

    default public CompletableFuture<CommitResult> commit(Revision baseRevision, long commitTimeMillis, Author author, String summary, String detail, Markup markup, Change<?> ... changes) {
        Objects.requireNonNull(changes, "changes");
        return this.commit(baseRevision, commitTimeMillis, author, summary, detail, markup, (Iterable<Change<?>>)ImmutableList.copyOf((Object[])changes), true);
    }

    public CompletableFuture<CommitResult> commit(Revision var1, long var2, Author var4, String var5, String var6, Markup var7, Iterable<Change<?>> var8, boolean var9);

    public CompletableFuture<CommitResult> commit(Revision var1, long var2, Author var4, String var5, String var6, Markup var7, ContentTransformer<?> var8);

    default public CompletableFuture<List<Commit>> history(Revision from, Revision to, String pathPattern) {
        return this.history(from, to, pathPattern, 100);
    }

    public CompletableFuture<List<Commit>> history(Revision var1, Revision var2, String var3, int var4);

    default public CompletableFuture<Revision> findLatestRevision(Revision lastKnownRevision, String pathPattern) {
        return this.findLatestRevision(lastKnownRevision, pathPattern, false);
    }

    public CompletableFuture<Revision> findLatestRevision(Revision var1, String var2, boolean var3);

    default public CompletableFuture<Revision> watch(Revision lastKnownRevision, String pathPattern) {
        return this.watch(lastKnownRevision, pathPattern, false);
    }

    public CompletableFuture<Revision> watch(Revision var1, String var2, boolean var3);

    default public <T> CompletableFuture<Entry<T>> watch(Revision lastKnownRevision, Query<T> query) {
        return this.watch(lastKnownRevision, query, false);
    }

    default public <T> CompletableFuture<Entry<T>> watch(Revision lastKnownRevision, Query<T> query, boolean errorOnEntryNotFound) {
        return RepositoryUtil.watch(this, lastKnownRevision, query, errorOnEntryNotFound);
    }

    default public <T> CompletableFuture<MergedEntry<T>> mergeFiles(Revision revision, MergeQuery<T> query) {
        Revision normalizedRevision;
        Objects.requireNonNull(revision, "revision");
        Objects.requireNonNull(query, "query");
        List mergeSources = query.mergeSources();
        mergeSources.forEach(path -> Util.validateJsonFilePath((String)path.path(), (String)"path"));
        try {
            normalizedRevision = this.normalizeNow(revision);
        }
        catch (Exception e) {
            return CompletableFutures.exceptionallyCompletedFuture((Throwable)e);
        }
        ArrayList entryFutures = new ArrayList(mergeSources.size());
        mergeSources.forEach(path -> {
            if (!path.isOptional()) {
                entryFutures.add(this.get(normalizedRevision, path.path()));
            } else {
                entryFutures.add(this.getOrNull(normalizedRevision, path.path()));
            }
        });
        CompletableFuture<MergedEntry<?>> mergedEntryFuture = RepositoryUtil.mergeEntries(entryFutures, revision, query);
        CompletableFuture future = new CompletableFuture();
        mergedEntryFuture.handle((mergedEntry, cause) -> {
            if (cause != null) {
                if (!(cause instanceof CentralDogmaException)) {
                    cause = new QueryExecutionException(cause);
                }
                future.completeExceptionally((Throwable)cause);
                return null;
            }
            future.complete((MergedEntry)Util.unsafeCast((Object)mergedEntry));
            return null;
        });
        return future;
    }

    public <T> CompletableFuture<T> execute(CacheableCall<T> var1);

    public void addListener(RepositoryListener var1);

    public boolean isEncrypted();
}

