/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.storage.encryption;

import com.linecorp.centraldogma.internal.shaded.guava.base.MoreObjects;
import com.linecorp.centraldogma.internal.shaded.guava.base.Preconditions;
import java.util.Objects;
import javax.crypto.SecretKey;

public final class SecretKeyWithVersion {
    private final SecretKey secretKey;
    private final int version;

    public SecretKeyWithVersion(SecretKey secretKey, int version) {
        this.secretKey = Objects.requireNonNull(secretKey, "secretKey");
        Preconditions.checkArgument((version >= 1 ? 1 : 0) != 0, (String)"version: %s (expected: >= 1)", (int)version);
        this.version = version;
    }

    public SecretKey secretKey() {
        return this.secretKey;
    }

    public int version() {
        return this.version;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("secretKey", (Object)"****").add("version", this.version).toString();
    }
}

