/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.storage.encryption;

import com.linecorp.armeria.common.util.UnmodifiableFuture;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.centraldogma.server.auth.SessionKey;
import com.linecorp.centraldogma.server.auth.SessionMasterKey;
import com.linecorp.centraldogma.server.storage.encryption.EncryptionStorageManager;
import com.linecorp.centraldogma.server.storage.encryption.KeyWrapper;
import com.linecorp.centraldogma.server.storage.encryption.RepositoryEncryptionStorage;
import com.linecorp.centraldogma.server.storage.encryption.RocksDBStorage;
import com.linecorp.centraldogma.server.storage.encryption.SecretKeyWithVersion;
import com.linecorp.centraldogma.server.storage.encryption.SessionKeyStorage;
import com.linecorp.centraldogma.server.storage.encryption.WrappedDekDetails;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import javax.crypto.SecretKey;

final class DefaultEncryptionStorageManager
implements EncryptionStorageManager {
    static final String ROCKSDB_PATH = "_rocks";
    private final boolean encryptSessionCookie;
    private final String kekId;
    private final RocksDBStorage rocksDbStorage;
    private final SessionKeyStorage sessionKeyStorage;
    private final RepositoryEncryptionStorage repositoryEncryptionStorage;

    DefaultEncryptionStorageManager(String rocksDbPath, boolean encryptSessionCookie, String kekId) {
        Objects.requireNonNull(rocksDbPath, "rocksDbPath");
        this.encryptSessionCookie = encryptSessionCookie;
        this.kekId = Objects.requireNonNull(kekId, "kekId");
        ImmutableList keyWrappers = ImmutableList.copyOf(ServiceLoader.load(KeyWrapper.class, EncryptionStorageManager.class.getClassLoader()));
        if (keyWrappers.size() != 1) {
            throw new IllegalStateException("A single KeyWrapper implementation must be provided. found: " + String.valueOf(keyWrappers));
        }
        KeyWrapper keyWrapper = (KeyWrapper)keyWrappers.get(0);
        this.rocksDbStorage = new RocksDBStorage(rocksDbPath);
        this.sessionKeyStorage = new SessionKeyStorage(this.rocksDbStorage, keyWrapper, kekId);
        this.repositoryEncryptionStorage = new RepositoryEncryptionStorage(this.rocksDbStorage, keyWrapper, kekId);
    }

    @Override
    public boolean enabled() {
        return true;
    }

    @Override
    public boolean encryptSessionCookie() {
        return this.encryptSessionCookie;
    }

    @Override
    public String kekId() {
        return this.kekId;
    }

    @Override
    public CompletableFuture<SessionMasterKey> generateSessionMasterKey(int version) {
        return this.sessionKeyStorage.generateSessionMasterKey(version);
    }

    @Override
    public void storeSessionMasterKey(SessionMasterKey sessionMasterKey) {
        this.sessionKeyStorage.storeSessionMasterKey(sessionMasterKey);
    }

    @Override
    public SessionMasterKey getCurrentSessionMasterKey() {
        return this.sessionKeyStorage.getCurrentSessionMasterKey();
    }

    @Override
    public CompletableFuture<SessionKey> getCurrentSessionKey() {
        return this.sessionKeyStorage.getCurrentSessionKey();
    }

    @Override
    public CompletableFuture<SessionKey> getSessionKey(int version) {
        return this.sessionKeyStorage.getSessionKey(version);
    }

    @Override
    public void rotateSessionMasterKey(SessionMasterKey sessionMasterKey) {
        this.sessionKeyStorage.rotateSessionMasterKey(sessionMasterKey);
    }

    @Override
    public CompletableFuture<String> generateWdek() {
        return this.repositoryEncryptionStorage.generateWdek();
    }

    @Override
    public List<WrappedDekDetails> wdeks() {
        return this.repositoryEncryptionStorage.wdeks();
    }

    @Override
    public SecretKey getDek(String projectName, String repoName, int version) {
        return this.repositoryEncryptionStorage.getDek(projectName, repoName, version);
    }

    @Override
    public SecretKeyWithVersion getCurrentDek(String projectName, String repoName) {
        return this.repositoryEncryptionStorage.getCurrentDek(projectName, repoName);
    }

    @Override
    public void storeWdek(WrappedDekDetails wdekDetails) {
        this.repositoryEncryptionStorage.storeWdek(wdekDetails);
    }

    @Override
    public void rotateWdek(WrappedDekDetails wdekDetails) {
        this.repositoryEncryptionStorage.rotateWdek(wdekDetails);
    }

    @Override
    public void removeWdek(String projectName, String repoName, int version, boolean removeCurrent) {
        this.repositoryEncryptionStorage.removeWdek(projectName, repoName, version, true);
    }

    @Override
    public byte[] getObject(byte[] key, byte[] metadataKey) {
        return this.repositoryEncryptionStorage.getObject(key, metadataKey);
    }

    @Override
    public byte[] getObjectId(byte[] key, byte[] metadataKey) {
        return this.repositoryEncryptionStorage.getObjectId(key, metadataKey);
    }

    @Override
    public byte[] getMetadata(byte[] metadataKey) {
        return this.repositoryEncryptionStorage.getMetadata(metadataKey);
    }

    @Override
    public void putObject(byte[] metadataKey, byte[] metadataValue, byte[] key, byte[] value) {
        this.repositoryEncryptionStorage.putObject(metadataKey, metadataValue, key, value);
    }

    @Override
    public void putObjectId(byte[] metadataKey, byte[] metadataValue, byte[] key, byte[] value, @Nullable byte[] previousKeyToRemove) {
        this.repositoryEncryptionStorage.putObjectId(metadataKey, metadataValue, key, value, previousKeyToRemove);
    }

    @Override
    public boolean containsMetadata(byte[] key) {
        return this.repositoryEncryptionStorage.containsMetadata(key);
    }

    @Override
    public void deleteObjectId(byte[] metadataKey, byte[] key) {
        this.repositoryEncryptionStorage.deleteObjectId(metadataKey, key);
    }

    @Override
    public void deleteRepositoryData(String projectName, String repoName) {
        this.repositoryEncryptionStorage.deleteRepositoryData(projectName, repoName);
    }

    @Override
    public void reencryptRepositoryData(String projectName, String repoName) {
        this.repositoryEncryptionStorage.reencryptRepositoryData(projectName, repoName);
    }

    @Override
    public Map<String, Map<String, byte[]>> getAllData() {
        return this.repositoryEncryptionStorage.getAllData();
    }

    @Override
    public void addSessionKeyListener(Consumer<SessionKey> listener) {
        this.sessionKeyStorage.addSessionKeyListener(listener);
    }

    @Override
    public void addCurrentDekListener(String projectName, String repoName, Consumer<SecretKeyWithVersion> listener) {
        this.repositoryEncryptionStorage.addCurrentDekListener(projectName, repoName, listener);
    }

    @Override
    public void removeCurrentDekListener(String projectName, String repoName) {
        this.repositoryEncryptionStorage.removeCurrentDekListener(projectName, repoName);
    }

    @Override
    public CompletableFuture<Void> rewrapAllKeys(Executor executor) {
        return this.repositoryEncryptionStorage.rewrapAllWdeks(executor).thenCompose(unused -> {
            if (this.encryptSessionCookie) {
                return this.sessionKeyStorage.rewrapAllSessionMasterKeys(executor);
            }
            return UnmodifiableFuture.completedFuture(null);
        });
    }

    public void close() {
        this.rocksDbStorage.close();
    }
}

