/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.mirror;

import com.linecorp.centraldogma.internal.shaded.guava.base.Preconditions;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class MirrorUtil {
    private static final Pattern MIRROR_ID_PATTERN = Pattern.compile("^[a-zA-Z](?:[a-zA-Z0-9-_.]{0,61}[a-zA-Z0-9])?$");

    public static void validateMirrorId(String id) {
        Matcher matcher = MIRROR_ID_PATTERN.matcher(id);
        Preconditions.checkArgument((boolean)matcher.matches(), (String)"invalid mirror ID: %s (expected: %s)", (Object)id, (Object)MIRROR_ID_PATTERN.pattern());
    }

    public static String normalizePath(String path) {
        Objects.requireNonNull(path, "path");
        if (((String)path).isEmpty()) {
            return "/";
        }
        if (!((String)path).startsWith("/")) {
            path = "/" + (String)path;
        }
        if (!((String)path).endsWith("/")) {
            path = (String)path + "/";
        }
        return ((String)path).replaceAll("//+", "/");
    }

    private MirrorUtil() {
    }
}

