/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.metadata;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.linecorp.centraldogma.common.RepositoryRole;
import com.linecorp.centraldogma.common.RepositoryStatus;
import com.linecorp.centraldogma.internal.shaded.guava.base.MoreObjects;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableMap;
import com.linecorp.centraldogma.server.metadata.Identifiable;
import com.linecorp.centraldogma.server.metadata.ProjectRoles;
import com.linecorp.centraldogma.server.metadata.Roles;
import com.linecorp.centraldogma.server.metadata.UserAndTimestamp;
import com.linecorp.centraldogma.server.storage.repository.HasWeight;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public final class RepositoryMetadata
implements Identifiable,
HasWeight {
    public static final ProjectRoles DEFAULT_PROJECT_ROLES = ProjectRoles.of(RepositoryRole.WRITE, null);
    private final String name;
    private final Roles roles;
    @Nullable
    private final UserAndTimestamp creation;
    @Nullable
    private final UserAndTimestamp removal;
    private final RepositoryStatus repositoryStatus;

    public static RepositoryMetadata of(String name, UserAndTimestamp creation) {
        return new RepositoryMetadata(name, creation, DEFAULT_PROJECT_ROLES);
    }

    public static RepositoryMetadata of(String name, Roles roles, UserAndTimestamp creation) {
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(roles, "roles");
        Objects.requireNonNull(creation, "creation");
        return new RepositoryMetadata(name, roles, creation, null, RepositoryStatus.ACTIVE);
    }

    public static RepositoryMetadata of(String name, UserAndTimestamp creation, ProjectRoles projectRoles) {
        return new RepositoryMetadata(name, creation, projectRoles);
    }

    public static RepositoryMetadata ofDogma(RepositoryStatus repositoryStatus) {
        return new RepositoryMetadata("dogma", Roles.EMPTY, null, null, repositoryStatus);
    }

    private RepositoryMetadata(String name, UserAndTimestamp creation, ProjectRoles projectRoles) {
        this(name, new Roles(Objects.requireNonNull(projectRoles, "projectRoles"), (Map<String, RepositoryRole>)ImmutableMap.of(), (Map<String, RepositoryRole>)ImmutableMap.of()), creation, null, RepositoryStatus.ACTIVE);
    }

    @JsonCreator
    public RepositoryMetadata(@JsonProperty(value="name") String name, @JsonProperty(value="roles") Roles roles, @JsonProperty(value="creation") @Nullable UserAndTimestamp creation, @JsonProperty(value="removal") @Nullable UserAndTimestamp removal, @JsonProperty(value="status") @Nullable RepositoryStatus repositoryStatus) {
        this.name = Objects.requireNonNull(name, "name");
        this.roles = Objects.requireNonNull(roles, "roles");
        if (!"dogma".equals(name)) {
            Objects.requireNonNull(creation, "creation");
        }
        this.creation = creation;
        this.removal = removal;
        this.repositoryStatus = (RepositoryStatus)MoreObjects.firstNonNull((Object)repositoryStatus, (Object)RepositoryStatus.ACTIVE);
    }

    @Override
    public String id() {
        return this.name;
    }

    @JsonProperty
    public String name() {
        return this.name;
    }

    @JsonProperty
    public Roles roles() {
        return this.roles;
    }

    @Nullable
    @JsonProperty
    public UserAndTimestamp creation() {
        return this.creation;
    }

    @Nullable
    @JsonProperty
    public UserAndTimestamp removal() {
        return this.removal;
    }

    @JsonProperty
    public RepositoryStatus status() {
        return this.repositoryStatus;
    }

    @Override
    public int weight() {
        int weight = 0;
        weight += this.name.length();
        return weight += this.roles.weight();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RepositoryMetadata that = (RepositoryMetadata)o;
        return this.name.equals(that.name) && this.roles.equals(that.roles) && Objects.equals(this.creation, that.creation) && Objects.equals(this.removal, that.removal) && this.repositoryStatus == that.repositoryStatus;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.roles, this.creation, this.removal, this.repositoryStatus);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("name", (Object)this.name).add("roles", (Object)this.roles).add("creation", (Object)this.creation).add("removal", (Object)this.removal).add("repositoryStatus", (Object)this.repositoryStatus).toString();
    }
}

