/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.storage.repository.git.rocksdb;

import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.centraldogma.server.internal.EmptyGitConfig;
import com.linecorp.centraldogma.server.internal.storage.repository.git.rocksdb.EncryptionGitStorage;
import com.linecorp.centraldogma.server.internal.storage.repository.git.rocksdb.RocksDbObjectDatabase;
import com.linecorp.centraldogma.server.internal.storage.repository.git.rocksdb.RocksDbRefDatabase;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Objects;
import org.eclipse.jgit.attributes.AttributesNode;
import org.eclipse.jgit.attributes.AttributesNodeProvider;
import org.eclipse.jgit.lib.BaseRepositoryBuilder;
import org.eclipse.jgit.lib.ObjectDatabase;
import org.eclipse.jgit.lib.RefDatabase;
import org.eclipse.jgit.lib.ReflogReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryBuilder;
import org.eclipse.jgit.lib.StoredConfig;

public final class RocksDbRepository
extends Repository {
    private final String identifier;
    private final EncryptionGitStorage encryptionGitStorage;
    private final RocksDbObjectDatabase rocksDbObjectDatabase;
    private final RocksDbRefDatabase refDatabase;

    public RocksDbRepository(EncryptionGitStorage encryptionGitStorage) {
        super((BaseRepositoryBuilder)new RepositoryBuilder());
        this.identifier = encryptionGitStorage.projectName() + "/" + encryptionGitStorage.repoName();
        this.encryptionGitStorage = Objects.requireNonNull(encryptionGitStorage, "encryptionGitStorage");
        this.rocksDbObjectDatabase = new RocksDbObjectDatabase(encryptionGitStorage);
        this.refDatabase = new RocksDbRefDatabase(this);
    }

    public EncryptionGitStorage encryptionGitStorage() {
        return this.encryptionGitStorage;
    }

    public void create(boolean bare) throws IOException {
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public ObjectDatabase getObjectDatabase() {
        return this.rocksDbObjectDatabase;
    }

    public RefDatabase getRefDatabase() {
        return this.refDatabase;
    }

    public StoredConfig getConfig() {
        return EmptyGitConfig.INSTANCE;
    }

    public AttributesNodeProvider createAttributesNodeProvider() {
        return EmptyAttributesNodeProvider.EMPTY_ATTRIBUTES_NODE_PROVIDER;
    }

    public void scanForRepoChanges() throws IOException {
    }

    public void notifyIndexChanged(boolean internal) {
    }

    public ReflogReader getReflogReader(String refName) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void close() {
        super.close();
        this.encryptionGitStorage.close();
    }

    private static class EmptyAttributesNodeProvider
    implements AttributesNodeProvider {
        static final EmptyAttributesNodeProvider EMPTY_ATTRIBUTES_NODE_PROVIDER = new EmptyAttributesNodeProvider();
        private final EmptyAttributesNode emptyAttributesNode = new EmptyAttributesNode();

        private EmptyAttributesNodeProvider() {
        }

        public AttributesNode getInfoAttributesNode() throws IOException {
            return this.emptyAttributesNode;
        }

        public AttributesNode getGlobalAttributesNode() throws IOException {
            return this.emptyAttributesNode;
        }

        private static class EmptyAttributesNode
        extends AttributesNode {
            EmptyAttributesNode() {
                super((List)ImmutableList.of());
            }

            public void parse(InputStream in) throws IOException {
            }
        }
    }
}

