/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.storage.repository.git.rocksdb;

import com.linecorp.centraldogma.server.internal.storage.repository.git.rocksdb.EncryptionGitStorage;
import com.linecorp.centraldogma.server.internal.storage.repository.git.rocksdb.RocksDbObjectReader;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.transport.PackParser;
import org.eclipse.jgit.util.IO;

final class RocksDbObjectInserter
extends ObjectInserter {
    private final EncryptionGitStorage encryptionGitStorage;
    private final RocksDbObjectReader reader;

    RocksDbObjectInserter(EncryptionGitStorage encryptionGitStorage, RocksDbObjectReader reader) {
        this.encryptionGitStorage = encryptionGitStorage;
        this.reader = reader;
    }

    public ObjectId insert(int type, byte[] data, int off, int len) throws IOException {
        ObjectId id = this.idFor(type, data, off, len);
        return this.encryptionGitStorage.insertObject(id, type, data, off, len);
    }

    public ObjectId insert(int type, long length, InputStream in) throws IOException {
        byte[] buf = length <= (long)this.buffer().length ? this.buffer() : new byte[(int)length];
        int actLen = IO.readFully((InputStream)in, (byte[])buf, (int)0);
        return this.insert(type, buf, 0, actLen);
    }

    public PackParser newPackParser(InputStream in) throws IOException {
        throw new UnsupportedOperationException();
    }

    public ObjectReader newReader() {
        return this.reader;
    }

    public void flush() throws IOException {
    }

    public void close() {
    }
}

