/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.storage.repository;

import com.github.benmanes.caffeine.cache.AsyncCache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.CaffeineSpec;
import com.linecorp.armeria.common.util.SafeCloseable;
import com.linecorp.armeria.internal.common.RequestContextUtil;
import com.linecorp.centraldogma.internal.shaded.guava.base.MoreObjects;
import com.linecorp.centraldogma.server.storage.repository.CacheableCall;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.cache.CaffeineCacheMetrics;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RepositoryCache {
    public static final Logger logger = LoggerFactory.getLogger(RepositoryCache.class);
    private final AsyncCache<CacheableCall, Object> cache;
    private final String cacheSpec;

    @Nullable
    public static String validateCacheSpec(@Nullable String cacheSpec) {
        if (cacheSpec == null) {
            return null;
        }
        try {
            CaffeineSpec.parse((String)cacheSpec);
            return cacheSpec;
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("cacheSpec: " + cacheSpec + " (" + e.getMessage() + ")");
        }
    }

    public RepositoryCache(String cacheSpec, MeterRegistry meterRegistry) {
        this.cacheSpec = Objects.requireNonNull(RepositoryCache.validateCacheSpec(cacheSpec), "cacheSpec");
        Objects.requireNonNull(meterRegistry, "meterRegistry");
        Caffeine builder = Caffeine.from((String)cacheSpec);
        if (cacheSpec.contains("maximumWeight=")) {
            builder.weigher(CacheableCall::weigh);
        }
        this.cache = builder.recordStats().buildAsync();
        CaffeineCacheMetrics.monitor((MeterRegistry)meterRegistry, this.cache, (String)"repository", (String[])new String[0]);
    }

    public <T> CompletableFuture<T> get(CacheableCall<T> call) {
        Objects.requireNonNull(call, "call");
        CompletableFuture future = new CompletableFuture();
        CompletableFuture prior = this.cache.asMap().putIfAbsent(call, future);
        if (prior != null) {
            return prior;
        }
        call.execute().handle((result, cause) -> {
            try (SafeCloseable ignored = RequestContextUtil.pop();){
                if (cause != null) {
                    future.completeExceptionally((Throwable)cause);
                } else {
                    future.complete(result);
                }
            }
            return null;
        });
        return future;
    }

    public void clear() {
        this.cache.synchronous().invalidateAll();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("spec", (Object)this.cacheSpec).add("stats", (Object)this.cache.synchronous().stats()).toString();
    }
}

