/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.storage.project;

import com.linecorp.centraldogma.common.Author;
import com.linecorp.centraldogma.common.PermissionException;
import com.linecorp.centraldogma.common.Revision;
import com.linecorp.centraldogma.server.command.Command;
import com.linecorp.centraldogma.server.command.CommandExecutor;
import com.linecorp.centraldogma.server.internal.admin.auth.AuthUtil;
import com.linecorp.centraldogma.server.metadata.MetadataService;
import com.linecorp.centraldogma.server.metadata.ProjectMetadata;
import com.linecorp.centraldogma.server.metadata.User;
import com.linecorp.centraldogma.server.metadata.UserWithToken;
import com.linecorp.centraldogma.server.storage.encryption.EncryptionStorageException;
import com.linecorp.centraldogma.server.storage.encryption.EncryptionStorageManager;
import com.linecorp.centraldogma.server.storage.encryption.WrappedDekDetails;
import com.linecorp.centraldogma.server.storage.project.Project;
import com.linecorp.centraldogma.server.storage.project.ProjectManager;
import java.time.Instant;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;

public final class ProjectApiManager {
    private final ProjectManager projectManager;
    private final CommandExecutor commandExecutor;
    private final MetadataService metadataService;
    private final EncryptionStorageManager encryptionStorageManager;

    public ProjectApiManager(ProjectManager projectManager, CommandExecutor commandExecutor, MetadataService metadataService, EncryptionStorageManager encryptionStorageManager) {
        this.projectManager = projectManager;
        this.commandExecutor = commandExecutor;
        this.metadataService = metadataService;
        this.encryptionStorageManager = encryptionStorageManager;
    }

    public Map<String, Project> listProjects(@Nullable User user) {
        Map<String, Project> projects = this.projectManager.list();
        if (ProjectApiManager.isSystemAdmin()) {
            return projects;
        }
        return ProjectApiManager.listProjectsWithoutInternal(projects, user);
    }

    private static boolean isSystemAdmin() {
        User currentUserOrNull = AuthUtil.currentUserOrNull();
        if (currentUserOrNull == null) {
            return false;
        }
        return currentUserOrNull.isSystemAdmin();
    }

    public static Map<String, Project> listProjectsWithoutInternal(Map<String, Project> projects, @Nullable User user) {
        LinkedHashMap<String, Project> result = new LinkedHashMap<String, Project>(projects.size() - 1);
        for (Map.Entry<String, Project> entry : projects.entrySet()) {
            if (ProjectApiManager.isInternalProject(entry.getKey())) {
                ProjectMetadata metadata;
                if (user == null || (metadata = entry.getValue().metadata()) == null) continue;
                if (user instanceof UserWithToken) {
                    if (metadata.tokenOrDefault(((UserWithToken)user).token().appId(), null) == null) continue;
                    result.put(entry.getKey(), entry.getValue());
                    continue;
                }
                if (metadata.memberOrDefault(user.id(), null) == null) continue;
                result.put(entry.getKey(), entry.getValue());
                continue;
            }
            result.put(entry.getKey(), entry.getValue());
        }
        return Collections.unmodifiableMap(result);
    }

    public Map<String, Instant> listRemovedProjects() {
        return this.projectManager.listRemoved();
    }

    public CompletableFuture<Void> createProject(String projectName, Author author) {
        ProjectApiManager.checkInternalProject(projectName, "create");
        if (!this.encryptionStorageManager.enabled()) {
            return this.commandExecutor.execute(Command.createProject(author, projectName));
        }
        return ((CompletableFuture)this.encryptionStorageManager.generateWdek().thenCompose(wdek -> {
            WrappedDekDetails wdekDetails = new WrappedDekDetails((String)wdek, 1, this.encryptionStorageManager.kekId(), projectName, "dogma");
            return this.commandExecutor.execute(Command.createProject(author, projectName, wdekDetails));
        })).exceptionally(cause -> {
            throw new EncryptionStorageException("Failed to create encrypted project " + projectName, (Throwable)cause);
        });
    }

    private static void checkInternalProject(String projectName, String operation) {
        if (ProjectApiManager.isInternalProject(projectName)) {
            throw new IllegalArgumentException("Cannot " + operation + " " + projectName);
        }
    }

    public CompletableFuture<ProjectMetadata> getProjectMetadata(String projectName) {
        return this.metadataService.getProject(projectName);
    }

    public CompletableFuture<Void> removeProject(String projectName, Author author) {
        ProjectApiManager.checkInternalProject(projectName, "remove");
        return this.metadataService.removeProject(author, projectName).thenCompose(unused -> this.commandExecutor.execute(Command.removeProject(author, projectName)));
    }

    public CompletableFuture<Void> purgeProject(String projectName, Author author) {
        ProjectApiManager.checkInternalProject(projectName, "purge");
        return this.commandExecutor.execute(Command.purgeProject(author, projectName));
    }

    public CompletableFuture<Revision> unremoveProject(String projectName, Author author) {
        ProjectApiManager.checkInternalProject(projectName, "unremove");
        return this.commandExecutor.execute(Command.unremoveProject(author, projectName)).thenCompose(unused -> this.metadataService.restoreProject(author, projectName));
    }

    public Project getProject(String projectName) {
        return this.getProject(projectName, AuthUtil.currentUserOrNull());
    }

    public Project getProject(String projectName, @Nullable User user) {
        Project project = (Project)this.projectManager.get(projectName);
        if (!ProjectApiManager.isInternalProject(projectName)) {
            return project;
        }
        if (user == null) {
            throw new IllegalArgumentException("Cannot access " + projectName);
        }
        if (user.isSystemAdmin()) {
            return project;
        }
        ProjectMetadata metadata = project.metadata();
        if (metadata != null && (user instanceof UserWithToken ? metadata.tokenOrDefault(((UserWithToken)user).token().appId(), null) != null : metadata.memberOrDefault(user.id(), null) != null)) {
            return project;
        }
        throw new PermissionException("Cannot access " + projectName);
    }

    private static boolean isInternalProject(String projectName) {
        return projectName.startsWith("@") || "dogma".equals(projectName);
    }

    public boolean exists(String projectName) {
        if (ProjectApiManager.isInternalProject(projectName) && !ProjectApiManager.isSystemAdmin()) {
            throw new IllegalArgumentException("Cannot access " + projectName);
        }
        return this.projectManager.exists(projectName);
    }
}

