/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.storage.project;

import com.linecorp.centraldogma.common.Author;
import com.linecorp.centraldogma.common.CentralDogmaException;
import com.linecorp.centraldogma.common.ProjectExistsException;
import com.linecorp.centraldogma.common.ProjectNotFoundException;
import com.linecorp.centraldogma.internal.Util;
import com.linecorp.centraldogma.server.internal.storage.DirectoryBasedStorageManager;
import com.linecorp.centraldogma.server.internal.storage.project.DefaultProject;
import com.linecorp.centraldogma.server.internal.storage.repository.RepositoryCache;
import com.linecorp.centraldogma.server.internal.storage.repository.git.GitRepositoryManager;
import com.linecorp.centraldogma.server.storage.encryption.EncryptionStorageManager;
import com.linecorp.centraldogma.server.storage.project.Project;
import com.linecorp.centraldogma.server.storage.project.ProjectManager;
import io.micrometer.core.instrument.MeterRegistry;
import java.io.File;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultProjectManager
extends DirectoryBasedStorageManager<Project>
implements ProjectManager {
    private static final Logger logger = LoggerFactory.getLogger(DefaultProjectManager.class);
    private final Executor repositoryWorker;
    @Nullable
    private final RepositoryCache cache;

    public DefaultProjectManager(File rootDir, Executor repositoryWorker, Executor purgeWorker, MeterRegistry meterRegistry, @Nullable String cacheSpec, EncryptionStorageManager encryptionStorageManager) {
        super(rootDir, Project.class, purgeWorker, encryptionStorageManager);
        Objects.requireNonNull(meterRegistry, "meterRegistry");
        Objects.requireNonNull(repositoryWorker, "repositoryWorker");
        this.repositoryWorker = repositoryWorker;
        this.cache = cacheSpec != null ? new RepositoryCache(cacheSpec, meterRegistry) : null;
        this.init();
    }

    @Override
    public void close(Supplier<CentralDogmaException> failureCauseSupplier) {
        super.close(failureCauseSupplier);
        if (this.cache != null) {
            this.cache.clear();
        }
    }

    @Override
    protected Project openChild(File childDir) throws Exception {
        return new DefaultProject(childDir, this.repositoryWorker, this.purgeWorker(), this.cache, this.encryptionStorageManager());
    }

    @Override
    protected Project createChild(File childDir, Author author, long creationTimeMillis, boolean encrypt) throws Exception {
        return new DefaultProject(childDir, this.repositoryWorker, this.purgeWorker(), creationTimeMillis, author, this.cache, this.encryptionStorageManager(), encrypt);
    }

    @Override
    protected void closeChild(File childDir, Project child, Supplier<CentralDogmaException> failureCauseSupplier) {
        DefaultProject c = (DefaultProject)child;
        c.repos.close(failureCauseSupplier);
    }

    @Override
    protected CentralDogmaException newStorageExistsException(String name) {
        return ProjectExistsException.of((String)name);
    }

    @Override
    protected CentralDogmaException newStorageNotFoundException(String name) {
        return ProjectNotFoundException.of((String)name);
    }

    @Override
    protected void deletePurged(File file) {
        String projectName = GitRepositoryManager.removeInterfixAndPurgedSuffix(file.getName());
        logger.info("Deleting a purged project: {} ..", (Object)projectName);
        try {
            File[] childFiles = file.listFiles();
            if (childFiles != null) {
                for (File child : childFiles) {
                    if (!child.isDirectory() || !GitRepositoryManager.isEncryptedRepository(child)) continue;
                    String name = child.getName();
                    String repoName = name.endsWith(".removed") ? name.substring(0, name.length() - ".removed".length()) : (name.endsWith(".purged") ? GitRepositoryManager.removeInterfixAndPurgedSuffix(name) : name);
                    this.encryptionStorageManager().deleteRepositoryData(projectName, repoName);
                }
            }
            Util.deleteFileTree((File)file);
            logger.info("Deleted a purged project: {}.", (Object)projectName);
        }
        catch (IOException e) {
            logger.warn("Failed to delete a purged project: {}", (Object)projectName, (Object)e);
        }
    }
}

