/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.replication;

import com.linecorp.armeria.common.util.TextFormatter;
import com.linecorp.centraldogma.server.internal.replication.ReplicationMetrics;
import com.linecorp.centraldogma.server.internal.replication.ReplicationTimings;
import java.util.concurrent.TimeUnit;

final class DefaultReplicationTimings
implements ReplicationTimings {
    private final ReplicationMetrics metrics;
    private long executorSubmitStartNanos;
    private long executorQueueLatencyNanos;
    private long lockAcquisitionStartNanos;
    private long lockAcquisitionDurationNanos;
    private boolean lockAcquired;
    private long lockReleaseStartNanos;
    private long lockReleaseDurationNanos;
    private long commandExecutionStartNanos;
    private long commandExecutionDurationNanos;
    private boolean commandExecutionEnded;
    private long logReplayStartNanos;
    private long logReplayDurationNanos;
    private boolean logReplayEnded;
    private long logStoreStartNanos;
    private long logStoreDurationNanos;
    private boolean logStoreEnded;
    private long logStoreEndNanos;

    DefaultReplicationTimings(ReplicationMetrics metrics) {
        this.metrics = metrics;
    }

    @Override
    public void startExecutorSubmit() {
        this.executorSubmitStartNanos = System.nanoTime();
    }

    @Override
    public void startExecutorExecution() {
        this.executorQueueLatencyNanos = System.nanoTime() - this.executorSubmitStartNanos;
    }

    @Override
    public void startLockAcquisition(long startNanos) {
        this.lockAcquisitionStartNanos = startNanos;
    }

    @Override
    public void endLockAcquisition(boolean lockAcquired) {
        this.lockAcquisitionDurationNanos = System.nanoTime() - this.lockAcquisitionStartNanos;
        this.lockAcquired = lockAcquired;
    }

    @Override
    public void startLockRelease() {
        this.lockReleaseStartNanos = System.nanoTime();
    }

    @Override
    public void endLockRelease() {
        this.lockReleaseDurationNanos = System.nanoTime() - this.lockReleaseStartNanos;
    }

    @Override
    public void startCommandExecution() {
        this.commandExecutionStartNanos = System.nanoTime();
    }

    @Override
    public void endCommandExecution() {
        this.commandExecutionDurationNanos = System.nanoTime() - this.commandExecutionStartNanos;
        this.commandExecutionEnded = true;
    }

    @Override
    public void startLogReplay() {
        this.logReplayStartNanos = System.nanoTime();
    }

    @Override
    public void endLogReplay() {
        this.logReplayDurationNanos = System.nanoTime() - this.logReplayStartNanos;
        this.logReplayEnded = true;
    }

    @Override
    public void startLogStore() {
        this.logStoreStartNanos = System.nanoTime();
    }

    @Override
    public void endLogStore() {
        this.logStoreEndNanos = System.nanoTime();
        this.logStoreDurationNanos = this.logStoreEndNanos - this.logStoreStartNanos;
        this.logStoreEnded = true;
    }

    @Override
    public void record() {
        this.metrics.executorQueueLatencyTimer().record(this.executorQueueLatencyNanos, TimeUnit.NANOSECONDS);
        if (this.lockAcquired) {
            this.metrics.lockAcquireSuccessTimer().record(this.lockAcquisitionDurationNanos, TimeUnit.NANOSECONDS);
        } else {
            this.metrics.lockAcquireFailureTimer().record(this.lockAcquisitionDurationNanos, TimeUnit.NANOSECONDS);
        }
        this.metrics.lockReleaseTimer().record(this.lockReleaseDurationNanos, TimeUnit.NANOSECONDS);
        if (this.commandExecutionEnded) {
            this.metrics.commandExecutionTimer().record(this.commandExecutionDurationNanos, TimeUnit.NANOSECONDS);
        }
        if (this.logReplayEnded) {
            this.metrics.logReplayTimer().record(this.logReplayDurationNanos, TimeUnit.NANOSECONDS);
        }
        if (this.logStoreEnded) {
            this.metrics.logStoreTimer().record(this.logStoreDurationNanos, TimeUnit.NANOSECONDS);
        }
    }

    @Override
    public String toText() {
        if (!this.logStoreEnded) {
            return "{ not completed yet }";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("{total=");
        TextFormatter.appendElapsed((StringBuilder)sb, (long)(this.logStoreEndNanos - this.executorSubmitStartNanos));
        sb.append(", executorQueueLatency=");
        TextFormatter.appendElapsed((StringBuilder)sb, (long)this.executorQueueLatencyNanos);
        sb.append(", lockAcquisition=");
        TextFormatter.appendElapsed((StringBuilder)sb, (long)this.lockAcquisitionDurationNanos);
        sb.append(", lockRelease=");
        TextFormatter.appendElapsed((StringBuilder)sb, (long)this.lockReleaseDurationNanos);
        sb.append(", commandExecution=");
        TextFormatter.appendElapsed((StringBuilder)sb, (long)this.commandExecutionDurationNanos);
        sb.append(", logReplay=");
        TextFormatter.appendElapsed((StringBuilder)sb, (long)this.logReplayDurationNanos);
        sb.append(", logStore=");
        TextFormatter.appendElapsed((StringBuilder)sb, (long)this.logStoreDurationNanos);
        sb.append('}');
        return sb.toString();
    }
}

