/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.mirror;

import com.linecorp.armeria.common.util.SafeCloseable;
import com.linecorp.centraldogma.common.MirrorAccessException;
import com.linecorp.centraldogma.common.MirrorException;
import com.linecorp.centraldogma.internal.shaded.guava.base.MoreObjects;
import com.linecorp.centraldogma.server.CentralDogmaConfig;
import com.linecorp.centraldogma.server.command.CommandExecutor;
import com.linecorp.centraldogma.server.internal.ExecutorServiceUtil;
import com.linecorp.centraldogma.server.internal.mirror.MirrorSchedulingService;
import com.linecorp.centraldogma.server.internal.storage.project.ProjectApiManager;
import com.linecorp.centraldogma.server.metadata.User;
import com.linecorp.centraldogma.server.mirror.Mirror;
import com.linecorp.centraldogma.server.mirror.MirrorAccessController;
import com.linecorp.centraldogma.server.mirror.MirrorListener;
import com.linecorp.centraldogma.server.mirror.MirrorResult;
import com.linecorp.centraldogma.server.mirror.MirrorTask;
import com.linecorp.centraldogma.server.mirror.MirroringServicePluginConfig;
import com.linecorp.centraldogma.server.storage.repository.MetaRepository;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.binder.jvm.ExecutorServiceMetrics;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.io.File;
import java.time.Instant;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public final class MirrorRunner
implements SafeCloseable {
    private final ProjectApiManager projectApiManager;
    private final CommandExecutor commandExecutor;
    private final File workDir;
    private final MirroringServicePluginConfig mirrorConfig;
    private final ExecutorService worker;
    private final Map<MirrorKey, CompletableFuture<MirrorResult>> inflightRequests = new ConcurrentHashMap<MirrorKey, CompletableFuture<MirrorResult>>();
    @Nullable
    private final String currentZone;
    private final MirrorAccessController mirrorAccessController;

    public MirrorRunner(ProjectApiManager projectApiManager, CommandExecutor commandExecutor, CentralDogmaConfig cfg, MeterRegistry meterRegistry, MirrorAccessController mirrorAccessController) {
        this.projectApiManager = projectApiManager;
        this.commandExecutor = commandExecutor;
        this.workDir = new File(cfg.dataDir(), "_mirrors_manual");
        MirroringServicePluginConfig mirrorConfig = (MirroringServicePluginConfig)cfg.pluginConfigMap().get(MirroringServicePluginConfig.class);
        if (mirrorConfig == null) {
            mirrorConfig = MirroringServicePluginConfig.INSTANCE;
        }
        this.mirrorConfig = mirrorConfig;
        this.currentZone = cfg.zone() != null ? cfg.zone().currentZone() : null;
        this.mirrorAccessController = mirrorAccessController;
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(0, mirrorConfig.numMirroringThreads(), 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new DefaultThreadFactory("mirror-api-worker", true));
        threadPoolExecutor.allowCoreThreadTimeOut(true);
        this.worker = ExecutorServiceMetrics.monitor((MeterRegistry)meterRegistry, (ExecutorService)threadPoolExecutor, (String)"mirrorApiWorker", (Tag[])new Tag[0]);
    }

    public CompletableFuture<MirrorResult> run(String projectName, String repoName, String mirrorId, User user) {
        return this.inflightRequests.computeIfAbsent(new MirrorKey(projectName, repoName, mirrorId), key -> this.run((MirrorKey)key, user));
    }

    private CompletableFuture<MirrorResult> run(MirrorKey mirrorKey, User user) {
        try {
            CompletionStage future = this.metaRepo(mirrorKey.projectName).mirror(mirrorKey.repoName, mirrorKey.mirrorId).thenCompose(mirror -> {
                if (!mirror.enabled()) {
                    throw new MirrorException("The mirror is disabled: " + mirrorKey.repoName + "/" + mirrorKey.mirrorId);
                }
                return this.mirrorAccessController.isAllowed((Mirror)mirror).thenApplyAsync(allowed -> {
                    if (!allowed.booleanValue()) {
                        throw new MirrorAccessException("The mirroring from " + String.valueOf(mirror.remoteRepoUri()) + " is not allowed: " + mirrorKey.repoName + "/" + mirrorKey.mirrorId);
                    }
                    String zone = mirror.zone();
                    if (zone != null && !zone.equals(this.currentZone)) {
                        throw new MirrorException("The mirror is not in the current zone: " + this.currentZone);
                    }
                    MirrorTask mirrorTask = new MirrorTask((Mirror)mirror, user, Instant.now(), this.currentZone, false);
                    MirrorListener listener = MirrorSchedulingService.mirrorListener();
                    listener.onStart(mirrorTask);
                    try {
                        MirrorResult mirrorResult = mirror.mirror(this.workDir, this.commandExecutor, this.mirrorConfig.maxNumFilesPerMirror(), this.mirrorConfig.maxNumBytesPerMirror(), mirrorTask.triggeredTime());
                        listener.onComplete(mirrorTask, mirrorResult);
                        return mirrorResult;
                    }
                    catch (Exception e) {
                        listener.onError(mirrorTask, e);
                        throw e;
                    }
                }, (Executor)this.worker);
            });
            ((CompletableFuture)future).handleAsync((unused0, unused1) -> this.inflightRequests.remove(mirrorKey), (Executor)this.worker);
            return future;
        }
        catch (Throwable e) {
            this.inflightRequests.remove(mirrorKey);
            throw e;
        }
    }

    private MetaRepository metaRepo(String projectName) {
        return this.projectApiManager.getProject(projectName, null).metaRepo();
    }

    public void close() {
        boolean interrupted = ExecutorServiceUtil.terminate(this.worker);
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
        this.inflightRequests.clear();
    }

    private static final class MirrorKey {
        private final String projectName;
        private final String repoName;
        private final String mirrorId;

        private MirrorKey(String projectName, String repoName, String mirrorId) {
            this.projectName = projectName;
            this.repoName = repoName;
            this.mirrorId = mirrorId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof MirrorKey)) {
                return false;
            }
            MirrorKey mirrorKey = (MirrorKey)o;
            return this.projectName.equals(mirrorKey.projectName) && this.repoName.equals(mirrorKey.repoName) && this.mirrorId.equals(mirrorKey.mirrorId);
        }

        public int hashCode() {
            return Objects.hash(this.projectName, this.repoName, this.mirrorId);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("projectName", (Object)this.projectName).add("repoName", (Object)this.repoName).add("mirrorId", (Object)this.mirrorId).toString();
        }
    }
}

