/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.credential;

import com.linecorp.centraldogma.internal.shaded.guava.base.MoreObjects;
import com.linecorp.centraldogma.internal.shaded.guava.base.Objects;
import com.linecorp.centraldogma.server.credential.Credential;
import com.linecorp.centraldogma.server.credential.CredentialType;
import javax.annotation.Nullable;

abstract class AbstractCredential
implements Credential {
    @Nullable
    private final String name;
    private final String id;
    private final CredentialType type;

    AbstractCredential(@Nullable String name, CredentialType type) {
        this.name = name;
        this.id = AbstractCredential.extractId(name, type);
        this.type = java.util.Objects.requireNonNull(type, "type");
    }

    private static String extractId(@Nullable String name, CredentialType type) {
        if (name == null) {
            return "";
        }
        if (type == CredentialType.NONE && name.isEmpty()) {
            return "";
        }
        int lastIndex = name.lastIndexOf(47);
        if (lastIndex < 0) {
            return "";
        }
        return name.substring(lastIndex + 1);
    }

    @Override
    public final String id() {
        return this.id;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public final CredentialType type() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractCredential that = (AbstractCredential)o;
        return Objects.equal((Object)this.name, (Object)that.name) && this.type == that.type;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, this.type});
    }

    public final String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((Object)this).omitNullValues();
        helper.add("name", (Object)this.name);
        helper.add("type", (Object)this.type);
        this.addProperties(helper);
        return helper.toString();
    }

    abstract void addProperties(MoreObjects.ToStringHelper var1);
}

