/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.api.sysadmin;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.linecorp.centraldogma.internal.shaded.guava.base.MoreObjects;
import com.linecorp.centraldogma.internal.shaded.guava.base.Preconditions;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Objects;

public final class SessionMasterKeyDto {
    private final int version;
    private final String kekId;
    private final String creation;

    @JsonCreator
    public SessionMasterKeyDto(@JsonProperty(value="version") int version, @JsonProperty(value="kekId") String kekId, @JsonProperty(value="creation") Instant creation) {
        Preconditions.checkArgument((version > 0 ? 1 : 0) != 0, (String)"version must be positive: %s", (int)version);
        this.version = version;
        this.kekId = Objects.requireNonNull(kekId, "kekId");
        this.creation = DateTimeFormatter.ISO_INSTANT.format(Objects.requireNonNull(creation, "creation"));
    }

    @JsonProperty
    public int version() {
        return this.version;
    }

    @JsonProperty
    public String kekId() {
        return this.kekId;
    }

    @JsonProperty
    public String creation() {
        return this.creation;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("version", this.version).add("kekId", (Object)this.kekId).add("creation", (Object)this.creation).toString();
    }
}

