/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.api.converter;

import com.linecorp.armeria.common.AggregatedHttpRequest;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.annotation.RequestConverterFunction;
import com.linecorp.centraldogma.common.Revision;
import com.linecorp.centraldogma.internal.shaded.guava.annotations.VisibleForTesting;
import com.linecorp.centraldogma.internal.shaded.guava.base.Ascii;
import com.linecorp.centraldogma.internal.shaded.guava.base.MoreObjects;
import com.linecorp.centraldogma.internal.shaded.guava.base.Splitter;
import com.linecorp.centraldogma.internal.shaded.guava.base.Strings;
import java.lang.reflect.ParameterizedType;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public final class WatchRequestConverter
implements RequestConverterFunction {
    private static final long DEFAULT_TIMEOUT_MILLIS = TimeUnit.SECONDS.toMillis(120L);
    private static final Splitter preferenceSplitter = Splitter.on((char)',').omitEmptyStrings().trimResults();
    private static final Splitter tokenSplitter = Splitter.on((char)'=').omitEmptyStrings().trimResults();
    private static final String NOTIFY_ENTRY_NOT_FOUND = "notify-entry-not-found";

    @Nullable
    public WatchRequest convertRequest(ServiceRequestContext ctx, AggregatedHttpRequest request, Class<?> expectedResultType, @Nullable ParameterizedType expectedParameterizedResultType) throws Exception {
        boolean notifyEntryNotFound;
        long timeoutMillis;
        String ifNoneMatch = request.headers().get((CharSequence)HttpHeaderNames.IF_NONE_MATCH);
        if (Strings.isNullOrEmpty((String)ifNoneMatch)) {
            return null;
        }
        Revision lastKnownRevision = new Revision(this.extractRevision(ifNoneMatch));
        String prefer = request.headers().get((CharSequence)HttpHeaderNames.PREFER);
        if (!Strings.isNullOrEmpty((String)prefer)) {
            Map<String, String> tokens = WatchRequestConverter.extract(prefer);
            timeoutMillis = WatchRequestConverter.timeoutMillis(tokens, prefer);
            notifyEntryNotFound = WatchRequestConverter.notifyEntryNotFound(tokens);
        } else {
            timeoutMillis = DEFAULT_TIMEOUT_MILLIS;
            notifyEntryNotFound = false;
        }
        return new WatchRequest(lastKnownRevision, timeoutMillis, notifyEntryNotFound);
    }

    @VisibleForTesting
    String extractRevision(String ifNoneMatch) {
        int length = ifNoneMatch.length();
        if (length > 2 && ifNoneMatch.charAt(0) == '\"' && ifNoneMatch.charAt(length - 1) == '\"') {
            return ifNoneMatch.substring(1, length - 1);
        }
        if (length > 4 && ifNoneMatch.startsWith("W/\"") && ifNoneMatch.charAt(length - 1) == '\"') {
            return ifNoneMatch.substring(3, length - 1);
        }
        return ifNoneMatch;
    }

    private static Map<String, String> extract(String preferHeader) {
        Iterable preferences = preferenceSplitter.split((CharSequence)preferHeader);
        HashMap<String, String> tokens = new HashMap<String, String>();
        for (String preference : preferences) {
            Iterable split = tokenSplitter.split((CharSequence)preference);
            Iterator iterator = split.iterator();
            if (!iterator.hasNext()) continue;
            String token = (String)iterator.next();
            if (!iterator.hasNext()) continue;
            String value = (String)iterator.next();
            tokens.put(Ascii.toLowerCase((String)token), value);
        }
        return tokens;
    }

    private static long timeoutMillis(Map<String, String> tokens, String preferHeader) {
        long timeoutSeconds;
        String wait = tokens.get("wait");
        if (wait == null) {
            return WatchRequestConverter.rejectPreferHeader(preferHeader, "wait=seconds");
        }
        try {
            timeoutSeconds = Long.parseLong(wait);
        }
        catch (NumberFormatException e) {
            return WatchRequestConverter.rejectPreferHeader(preferHeader, "wait=seconds");
        }
        if (timeoutSeconds <= 0L) {
            return WatchRequestConverter.rejectPreferHeader(preferHeader, "seconds > 0");
        }
        return TimeUnit.SECONDS.toMillis(timeoutSeconds);
    }

    private static long rejectPreferHeader(String preferHeader, String expected) {
        throw new IllegalArgumentException("invalid prefer header: " + preferHeader + " (expected: " + expected + ")");
    }

    private static boolean notifyEntryNotFound(Map<String, String> tokens) {
        String notifyEntryNotFound = tokens.get(NOTIFY_ENTRY_NOT_FOUND);
        return "true".equalsIgnoreCase(notifyEntryNotFound);
    }

    public static class WatchRequest {
        private final Revision lastKnownRevision;
        private final long timeoutMillis;
        private final boolean notifyEntryNotFound;

        WatchRequest(Revision lastKnownRevision, long timeoutMillis, boolean notifyEntryNotFound) {
            this.lastKnownRevision = lastKnownRevision;
            this.timeoutMillis = timeoutMillis;
            this.notifyEntryNotFound = notifyEntryNotFound;
        }

        public Revision lastKnownRevision() {
            return this.lastKnownRevision;
        }

        public long timeoutMillis() {
            return this.timeoutMillis;
        }

        public boolean notifyEntryNotFound() {
            return this.notifyEntryNotFound;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("lastKnownRevision", (Object)this.lastKnownRevision).add("timeoutMillis", this.timeoutMillis).toString();
        }
    }
}

