/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.api.auth;

import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.armeria.common.util.UnmodifiableFuture;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.centraldogma.server.internal.admin.auth.AbstractAuthorizer;
import com.linecorp.centraldogma.server.internal.admin.auth.AuthUtil;
import com.linecorp.centraldogma.server.internal.api.HttpApiUtil;
import com.linecorp.centraldogma.server.metadata.Token;
import com.linecorp.centraldogma.server.metadata.TokenNotFoundException;
import com.linecorp.centraldogma.server.metadata.Tokens;
import com.linecorp.centraldogma.server.metadata.UserWithToken;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationTokenAuthorizer
extends AbstractAuthorizer {
    private static final Logger logger = LoggerFactory.getLogger(ApplicationTokenAuthorizer.class);
    private final Function<String, Token> tokenLookupFunc;

    public ApplicationTokenAuthorizer(Function<String, Token> tokenLookupFunc) {
        this.tokenLookupFunc = Objects.requireNonNull(tokenLookupFunc, "tokenLookupFunc");
    }

    @Override
    protected CompletionStage<Boolean> authorize(ServiceRequestContext ctx, HttpRequest req, String accessToken) {
        if (!Tokens.isValidSecret(accessToken)) {
            return CompletableFuture.completedFuture(false);
        }
        try {
            Token appToken = this.tokenLookupFunc.apply(accessToken);
            if (appToken != null && appToken.isActive()) {
                String appId = appToken.appId();
                ctx.logBuilder().authenticatedUser("app/" + appId);
                UserWithToken user = new UserWithToken(appToken);
                AuthUtil.setCurrentUser(ctx, user);
                HttpApiUtil.setVerboseResponses(ctx, user);
                return UnmodifiableFuture.completedFuture((Object)true);
            }
            return UnmodifiableFuture.completedFuture((Object)false);
        }
        catch (Throwable cause) {
            cause = Exceptions.peel((Throwable)cause);
            if (cause instanceof IllegalArgumentException || cause instanceof TokenNotFoundException) {
                logger.debug("Failed to authorize an application token: token={}, addr={}", (Object)ApplicationTokenAuthorizer.maskToken(accessToken), (Object)ctx.clientAddress());
            } else {
                logger.warn("Failed to authorize an application token: token={}, addr={}", new Object[]{ApplicationTokenAuthorizer.maskToken(accessToken), ctx.clientAddress(), cause});
            }
            return UnmodifiableFuture.completedFuture((Object)false);
        }
    }

    private static String maskToken(String token) {
        if (!token.startsWith("appToken-")) {
            return token;
        }
        int lastDash = token.lastIndexOf(45);
        if (lastDash == -1) {
            return token;
        }
        return token.substring(0, lastDash) + "-<redacted>";
    }
}

