/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.api;

import com.fasterxml.jackson.databind.JsonNode;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.logging.RequestOnlyLog;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.annotation.Consumes;
import com.linecorp.armeria.server.annotation.Delete;
import com.linecorp.armeria.server.annotation.Get;
import com.linecorp.armeria.server.annotation.Param;
import com.linecorp.armeria.server.annotation.Patch;
import com.linecorp.armeria.server.annotation.Post;
import com.linecorp.armeria.server.annotation.ProducesJson;
import com.linecorp.armeria.server.annotation.Put;
import com.linecorp.armeria.server.annotation.ResponseConverter;
import com.linecorp.armeria.server.annotation.StatusCode;
import com.linecorp.centraldogma.common.Author;
import com.linecorp.centraldogma.common.ProjectRole;
import com.linecorp.centraldogma.common.RepositoryRole;
import com.linecorp.centraldogma.common.RepositoryStatus;
import com.linecorp.centraldogma.common.Revision;
import com.linecorp.centraldogma.internal.api.v1.CreateRepositoryRequest;
import com.linecorp.centraldogma.internal.api.v1.RepositoryDto;
import com.linecorp.centraldogma.internal.shaded.guava.base.MoreObjects;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableMap;
import com.linecorp.centraldogma.server.command.Command;
import com.linecorp.centraldogma.server.command.CommandExecutor;
import com.linecorp.centraldogma.server.internal.api.AbstractService;
import com.linecorp.centraldogma.server.internal.api.DtoConverter;
import com.linecorp.centraldogma.server.internal.api.HttpApiUtil;
import com.linecorp.centraldogma.server.internal.api.RepositoryServiceUtil;
import com.linecorp.centraldogma.server.internal.api.UpdateRepositoryStatusRequest;
import com.linecorp.centraldogma.server.internal.api.auth.RequiresProjectRole;
import com.linecorp.centraldogma.server.internal.api.auth.RequiresRepositoryRole;
import com.linecorp.centraldogma.server.internal.api.auth.RequiresSystemAdministrator;
import com.linecorp.centraldogma.server.internal.api.converter.CreateApiResponseConverter;
import com.linecorp.centraldogma.server.metadata.MetadataService;
import com.linecorp.centraldogma.server.metadata.ProjectMetadata;
import com.linecorp.centraldogma.server.metadata.RepositoryMetadata;
import com.linecorp.centraldogma.server.metadata.User;
import com.linecorp.centraldogma.server.storage.encryption.EncryptionStorageManager;
import com.linecorp.centraldogma.server.storage.encryption.WrappedDekDetails;
import com.linecorp.centraldogma.server.storage.project.Project;
import com.linecorp.centraldogma.server.storage.repository.Repository;
import io.micrometer.core.instrument.Tag;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ProducesJson
public class RepositoryServiceV1
extends AbstractService {
    private static final Logger logger = LoggerFactory.getLogger(RepositoryServiceV1.class);
    private final MetadataService mds;
    private final EncryptionStorageManager encryptionStorageManager;

    public RepositoryServiceV1(CommandExecutor executor, MetadataService mds, EncryptionStorageManager encryptionStorageManager) {
        super(executor);
        this.mds = Objects.requireNonNull(mds, "mds");
        this.encryptionStorageManager = Objects.requireNonNull(encryptionStorageManager, "encryptionStorageManager");
    }

    @Get(value="/projects/{projectName}/repos")
    public CompletableFuture<List<RepositoryDto>> listRepositories(ServiceRequestContext ctx, Project project, @Param @Nullable String status, User user) {
        if (status != null) {
            HttpApiUtil.checkStatusArgument(status);
        }
        if ("dogma".equals(project.name())) {
            if (user.isSystemAdmin()) {
                if (status != null) {
                    return CompletableFuture.completedFuture(RepositoryServiceV1.removedRepositories(project));
                }
                return CompletableFuture.completedFuture((List)project.repos().list().values().stream().map(repository -> DtoConverter.convert(repository, RepositoryStatus.ACTIVE)).collect(ImmutableList.toImmutableList()));
            }
            return (CompletableFuture)HttpApiUtil.throwResponse(ctx, HttpStatus.FORBIDDEN, "You must be a system administrator to retrieve repositories of the dogma project.");
        }
        if (status == null) {
            Map<String, RepositoryMetadata> repos = RepositoryServiceV1.projectMetadata(project).repos();
            return CompletableFuture.completedFuture((List)project.repos().list().values().stream().filter(r -> user.isSystemAdmin() || !Project.isInternalRepo(r.name())).map(repository -> DtoConverter.convert(repository, repos)).collect(ImmutableList.toImmutableList()));
        }
        return this.mds.findProjectRole(project.name(), user).handle((role, throwable) -> {
            boolean hasOwnerRole;
            boolean bl = hasOwnerRole = role == ProjectRole.OWNER;
            if (hasOwnerRole) {
                return RepositoryServiceV1.removedRepositories(project);
            }
            return (List)HttpApiUtil.throwResponse(ctx, HttpStatus.FORBIDDEN, "You must be an owner of project '%s' to retrieve removed repositories.", project.name());
        });
    }

    private static ProjectMetadata projectMetadata(Project project) {
        assert (!"dogma".equals(project.name()));
        ProjectMetadata metadata = project.metadata();
        assert (metadata != null);
        return metadata;
    }

    private static RepositoryStatus repositoryStatus(Repository repository) {
        String repoName;
        Map<String, RepositoryMetadata> repos = RepositoryServiceV1.projectMetadata(repository.parent()).repos();
        RepositoryMetadata metadata = repos.get(repoName = RepositoryServiceV1.normalizeRepositoryName(repository));
        if (metadata == null) {
            return RepositoryStatus.ACTIVE;
        }
        return metadata.status();
    }

    private static String normalizeRepositoryName(Repository repository) {
        String repoName = repository.name();
        if (!"meta".equals(repoName)) {
            return repoName;
        }
        return "dogma";
    }

    private static ImmutableList<RepositoryDto> removedRepositories(Project project) {
        return (ImmutableList)project.repos().listRemoved().keySet().stream().map(RepositoryDto::removed).collect(ImmutableList.toImmutableList());
    }

    @Post(value="/projects/{projectName}/repos")
    @StatusCode(value=201)
    @ResponseConverter(value=CreateApiResponseConverter.class)
    @RequiresProjectRole(value=ProjectRole.MEMBER)
    public CompletableFuture<RepositoryDto> createRepository(ServiceRequestContext ctx, Project project, CreateRepositoryRequest request, Author author) {
        String repoName = request.name();
        if (Project.isInternalRepo(repoName)) {
            return (CompletableFuture)HttpApiUtil.throwResponse(ctx, HttpStatus.FORBIDDEN, "An internal repository cannot be created.");
        }
        if (request.encrypt() && !this.encryptionStorageManager.enabled()) {
            return (CompletableFuture)HttpApiUtil.throwResponse(ctx, HttpStatus.BAD_REQUEST, "Encryption is not enabled in the server.");
        }
        CommandExecutor commandExecutor = this.executor();
        CompletableFuture<Revision> future = RepositoryServiceUtil.createRepository(commandExecutor, this.mds, author, project.name(), repoName, request.encrypt(), this.encryptionStorageManager);
        return future.handle(HttpApiUtil.returnOrThrow(() -> {
            Repository repository = (Repository)project.repos().get(repoName);
            return DtoConverter.convert(repository, RepositoryServiceV1.repositoryStatus(repository));
        }));
    }

    @Delete(value="/projects/{projectName}/repos/{repoName}")
    @RequiresRepositoryRole(value=RepositoryRole.ADMIN)
    public CompletableFuture<Void> removeRepository(ServiceRequestContext ctx, @Param String repoName, Repository repository, Author author) {
        if (Project.isInternalRepo(repoName)) {
            return (CompletableFuture)HttpApiUtil.throwResponse(ctx, HttpStatus.FORBIDDEN, "An internal repository cannot be removed.");
        }
        return RepositoryServiceUtil.removeRepository(this.executor(), this.mds, author, repository.parent().name(), repoName).handle(HttpApiUtil::throwUnsafelyIfNonNull);
    }

    @Delete(value="/projects/{projectName}/repos/{repoName}/removed")
    @RequiresProjectRole(value=ProjectRole.OWNER)
    public CompletableFuture<Void> purgeRepository(@Param String repoName, Project project, Author author) {
        return this.execute(Command.purgeRepository(author, project.name(), repoName)).thenCompose(unused -> this.mds.purgeRepo(author, project.name(), repoName).handle(HttpApiUtil::throwUnsafelyIfNonNull));
    }

    @Consumes(value="application/json-patch+json")
    @Patch(value="/projects/{projectName}/repos/{repoName}")
    @RequiresProjectRole(value=ProjectRole.OWNER)
    public CompletableFuture<RepositoryDto> patchRepository(@Param String repoName, Project project, JsonNode node, Author author) {
        HttpApiUtil.checkUnremoveArgument(node);
        return ((CompletableFuture)this.execute(Command.unremoveRepository(author, project.name(), repoName)).thenCompose(unused -> this.mds.restoreRepo(author, project.name(), repoName))).handle(HttpApiUtil.returnOrThrow(() -> {
            Repository repository = (Repository)project.repos().get(repoName);
            return DtoConverter.convert(repository, RepositoryServiceV1.repositoryStatus(repository));
        }));
    }

    @Get(value="/projects/{projectName}/repos/{repoName}/revision/{revision}")
    @RequiresRepositoryRole(value=RepositoryRole.READ)
    public Map<String, Integer> normalizeRevision(ServiceRequestContext ctx, Repository repository, @Param String revision) {
        Revision normalizedRevision = repository.normalizeNow(new Revision(revision));
        Revision head = repository.normalizeNow(Revision.HEAD);
        RepositoryServiceV1.increaseCounterIfOldRevisionUsed(ctx, repository, normalizedRevision, head);
        return ImmutableMap.of((Object)"revision", (Object)normalizedRevision.major());
    }

    @Get(value="/projects/{projectName}/repos/{repoName}")
    @RequiresRepositoryRole(value=RepositoryRole.ADMIN)
    public RepositoryDto status(Project project, Repository repository) {
        RepositoryServiceV1.rejectIfDogmaProject(project);
        return DtoConverter.convert(repository, RepositoryServiceV1.repositoryStatus(repository));
    }

    @Put(value="/projects/{projectName}/repos/{repoName}/status")
    @Consumes(value="application/json")
    @RequiresRepositoryRole(value=RepositoryRole.ADMIN)
    public CompletableFuture<RepositoryDto> updateStatus(Project project, Repository repository, Author author, UpdateRepositoryStatusRequest statusRequest) {
        RepositoryServiceV1.rejectIfDogmaProject(project);
        RepositoryStatus oldStatus = RepositoryServiceV1.repositoryStatus(repository);
        RepositoryStatus newStatus = statusRequest.status();
        if (oldStatus == newStatus) {
            return CompletableFuture.completedFuture(DtoConverter.convert(repository, oldStatus));
        }
        return this.mds.updateRepositoryStatus(author, project.name(), RepositoryServiceV1.normalizeRepositoryName(repository), newStatus).thenApply(unused -> DtoConverter.convert(repository, newStatus));
    }

    @Post(value="/projects/{projectName}/repos/{repoName}/migrate/encrypted")
    @RequiresSystemAdministrator
    public CompletableFuture<RepositoryDto> migrateToEncryptedRepository(ServiceRequestContext ctx, Project project, Repository repository, Author author) {
        this.validateMigrationPrerequisites(ctx, project, repository);
        ctx.setRequestTimeoutMillis(Long.MAX_VALUE);
        return this.encryptionStorageManager.generateWdek().thenCompose(wdek -> this.setRepositoryStatus(author, project, repository, RepositoryStatus.READ_ONLY).thenCompose(unused -> {
            WrappedDekDetails wdekDetails = new WrappedDekDetails((String)wdek, 1, this.encryptionStorageManager.kekId(), project.name(), repository.name());
            return this.migrate(author, project, repository, wdekDetails);
        }));
    }

    private void validateMigrationPrerequisites(ServiceRequestContext ctx, Project project, Repository repository) {
        if (!this.encryptionStorageManager.enabled()) {
            throw new IllegalArgumentException("Encryption is not enabled in the server. Cannot migrate to an encrypted repository.");
        }
        if ("dogma".equals(project.name()) || project.name().startsWith("@") || "dogma".equals(repository.name())) {
            throw new IllegalArgumentException("Cannot migrate the internal project or repository to an encrypted repository. project: " + project.name() + ", repository: " + repository.name());
        }
        RepositoryStatus currentStatus = RepositoryServiceV1.repositoryStatus(repository);
        if (repository.isEncrypted()) {
            throw new IllegalArgumentException("The repository is already encrypted. Cannot migrate to an encrypted repository again. project: " + project.name() + ", repository: " + repository.name());
        }
        Revision normalizeNow = repository.normalizeNow(Revision.HEAD);
        if (normalizeNow.major() > 1000) {
            throw new IllegalArgumentException("Cannot migrate a repository with more than 1000 revisions to an encrypted repository.");
        }
        if (currentStatus == RepositoryStatus.READ_ONLY) {
            HttpApiUtil.throwResponse(ctx, HttpStatus.CONFLICT, "Cannot migrate a read-only repository to an encrypted repository. Please change the status to ACTIVE first.");
        }
    }

    private CompletableFuture<Void> setRepositoryStatus(Author author, Project project, Repository repository, RepositoryStatus status) {
        String projectName = project.name();
        String repoName = repository.name();
        logger.info("Changing repository status: project={}, repository={}, status={}", new Object[]{projectName, repoName, status});
        return this.mds.updateRepositoryStatus(author, projectName, repoName, status).handle((unused, cause) -> {
            if (cause != null) {
                logger.warn("Failed to change the repository status: project={}, repository={}, status={}", new Object[]{projectName, repoName, status, cause});
                Exceptions.throwUnsafely((Throwable)cause);
            } else {
                logger.info("Changed repository status: project={}, repository={}, status={}", new Object[]{projectName, repoName, status});
            }
            return null;
        });
    }

    private CompletionStage<RepositoryDto> migrate(Author author, Project project, Repository repository, WrappedDekDetails wdekDetails) {
        String projectName = project.name();
        String repoName = repository.name();
        logger.info("Starting repository encryption migration: project={}, repository={}", (Object)projectName, (Object)repoName);
        Command<Void> command = Command.migrateToEncryptedRepository(null, author, projectName, repoName, wdekDetails);
        return ((CompletableFuture)this.executor().execute(command).handle((unused, cause) -> {
            if (cause != null) {
                logger.warn("failed to migrate repository to an encrypted repository: project={}, repository={}", new Object[]{projectName, repoName, cause});
                return this.setRepositoryStatus(author, project, repository, RepositoryStatus.ACTIVE).thenApply(unused1 -> (RepositoryDto)Exceptions.throwUnsafely((Throwable)cause));
            }
            logger.info("Successfully migrated repository to an encrypted repository: project={}, repository={}", (Object)projectName, (Object)repoName);
            return this.setRepositoryStatus(author, project, repository, RepositoryStatus.ACTIVE).thenApply(unused1 -> {
                Repository updatedRepository = (Repository)project.repos().get(repository.name());
                return DtoConverter.convert(updatedRepository, RepositoryStatus.ACTIVE);
            });
        })).thenCompose(Function.identity());
    }

    static void increaseCounterIfOldRevisionUsed(ServiceRequestContext ctx, Repository repository, Revision revision) {
        Revision normalized = repository.normalizeNow(revision);
        Revision head = repository.normalizeNow(Revision.HEAD);
        RepositoryServiceV1.increaseCounterIfOldRevisionUsed(ctx, repository, normalized, head);
    }

    public static void increaseCounterIfOldRevisionUsed(ServiceRequestContext ctx, Repository repository, Revision normalized, Revision head) {
        String projectName = repository.parent().name();
        String repoName = repository.name();
        if (normalized.major() == 1) {
            ctx.log().whenRequestComplete().thenAccept(log -> ctx.meterRegistry().counter("revisions.init", (Iterable)RepositoryServiceV1.generateTags(projectName, repoName, log).build()).increment());
        }
        if (head.major() - normalized.major() >= 5000) {
            ctx.log().whenRequestComplete().thenAccept(log -> ctx.meterRegistry().summary("revisions.old", (Iterable)RepositoryServiceV1.generateTags(projectName, repoName, log).add((Object)Tag.of((String)"init", (String)Boolean.toString(normalized.major() == 1))).build()).record((double)(head.major() - normalized.major())));
        }
    }

    private static ImmutableList.Builder<Tag> generateTags(String projectName, String repoName, RequestOnlyLog log) {
        ImmutableList.Builder builder = ImmutableList.builder();
        return builder.add((Object[])new Tag[]{Tag.of((String)"project", (String)projectName), Tag.of((String)"repo", (String)repoName), Tag.of((String)"service", (String)((String)MoreObjects.firstNonNull((Object)log.serviceName(), (Object)"none"))), Tag.of((String)"method", (String)log.name())});
    }

    private static void rejectIfDogmaProject(Project project) {
        if ("dogma".equals(project.name())) {
            throw new IllegalArgumentException("Cannot update the status of the internal project: " + project.name());
        }
    }
}

