/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.api;

import com.linecorp.centraldogma.common.Author;
import com.linecorp.centraldogma.common.Change;
import com.linecorp.centraldogma.common.Commit;
import com.linecorp.centraldogma.common.Entry;
import com.linecorp.centraldogma.common.EntryType;
import com.linecorp.centraldogma.common.MergedEntry;
import com.linecorp.centraldogma.common.ProjectRole;
import com.linecorp.centraldogma.common.RepositoryStatus;
import com.linecorp.centraldogma.common.Revision;
import com.linecorp.centraldogma.internal.api.v1.ChangeDto;
import com.linecorp.centraldogma.internal.api.v1.CommitDto;
import com.linecorp.centraldogma.internal.api.v1.CommitMessageDto;
import com.linecorp.centraldogma.internal.api.v1.EntryDto;
import com.linecorp.centraldogma.internal.api.v1.MergedEntryDto;
import com.linecorp.centraldogma.internal.api.v1.ProjectDto;
import com.linecorp.centraldogma.internal.api.v1.PushResultDto;
import com.linecorp.centraldogma.internal.api.v1.RepositoryDto;
import com.linecorp.centraldogma.server.metadata.RepositoryMetadata;
import com.linecorp.centraldogma.server.storage.project.Project;
import com.linecorp.centraldogma.server.storage.repository.Repository;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

final class DtoConverter {
    public static ProjectDto convert(Project project, ProjectRole userRole) {
        Objects.requireNonNull(project, "project");
        return new ProjectDto(project.name(), project.author(), userRole, project.creationTimeMillis());
    }

    public static RepositoryDto convert(Repository repository, Map<String, RepositoryMetadata> metadataMap) {
        RepositoryMetadata metadata;
        Objects.requireNonNull(repository, "repository");
        RepositoryStatus status = metadataMap == null ? RepositoryStatus.ACTIVE : ((metadata = metadataMap.get(repository.name())) == null ? RepositoryStatus.ACTIVE : metadata.status());
        return DtoConverter.convert(repository, status);
    }

    public static RepositoryDto convert(Repository repository, RepositoryStatus status) {
        Revision headRevision = repository.normalizeNow(Revision.HEAD);
        String projectName = repository.parent().name();
        return new RepositoryDto(projectName, repository.name(), repository.author(), headRevision, repository.creationTimeMillis(), status);
    }

    public static <T> EntryDto<T> convert(Repository repository, Revision revision, Entry<T> entry, boolean withContent) {
        Objects.requireNonNull(entry, "entry");
        if (withContent && entry.hasContent()) {
            return DtoConverter.convert(repository, revision, entry.path(), entry.type(), entry.content());
        }
        return DtoConverter.convert(repository, revision, entry.path(), entry.type());
    }

    private static <T> EntryDto<T> convert(Repository repository, Revision revision, String path, EntryType type) {
        return DtoConverter.convert(repository, revision, path, type, null);
    }

    private static <T> EntryDto<T> convert(Repository repository, Revision revision, String path, EntryType type, @Nullable T content) {
        Objects.requireNonNull(repository, "repository");
        return new EntryDto(Objects.requireNonNull(revision, "revision"), Objects.requireNonNull(path, "path"), Objects.requireNonNull(type, "type"), repository.parent().name(), repository.name(), content);
    }

    public static PushResultDto convert(Revision revision, long commitTimeMillis) {
        return new PushResultDto(revision, commitTimeMillis);
    }

    public static CommitDto convert(Commit commit) {
        Objects.requireNonNull(commit, "commit");
        return DtoConverter.convert(commit.revision(), commit.author(), new CommitMessageDto(commit.summary(), commit.detail(), commit.markup()), commit.when());
    }

    public static CommitDto convert(Revision revision, Author author, CommitMessageDto commitMessage, long commitTimeMillis) {
        return new CommitDto(revision, author, commitMessage, commitTimeMillis);
    }

    public static <T> ChangeDto<T> convert(Change<T> change) {
        Objects.requireNonNull(change, "change");
        return new ChangeDto(change.path(), change.type(), change.content());
    }

    public static <T> MergedEntryDto<T> convert(MergedEntry<T> mergedEntry) {
        Objects.requireNonNull(mergedEntry, "mergedEntry");
        return new MergedEntryDto(mergedEntry.revision(), mergedEntry.type(), mergedEntry.content(), (Iterable)mergedEntry.paths());
    }

    private DtoConverter() {
    }
}

