/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.api;

import com.linecorp.armeria.server.annotation.ConsumesJson;
import com.linecorp.armeria.server.annotation.Delete;
import com.linecorp.armeria.server.annotation.Get;
import com.linecorp.armeria.server.annotation.Param;
import com.linecorp.armeria.server.annotation.Post;
import com.linecorp.armeria.server.annotation.ProducesJson;
import com.linecorp.armeria.server.annotation.Put;
import com.linecorp.armeria.server.annotation.StatusCode;
import com.linecorp.centraldogma.common.Author;
import com.linecorp.centraldogma.common.Change;
import com.linecorp.centraldogma.common.Markup;
import com.linecorp.centraldogma.common.ProjectRole;
import com.linecorp.centraldogma.common.RepositoryRole;
import com.linecorp.centraldogma.common.Revision;
import com.linecorp.centraldogma.internal.CredentialUtil;
import com.linecorp.centraldogma.internal.api.v1.PushResultDto;
import com.linecorp.centraldogma.internal.shaded.guava.base.Preconditions;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.centraldogma.server.command.Command;
import com.linecorp.centraldogma.server.command.CommandExecutor;
import com.linecorp.centraldogma.server.command.CommitResult;
import com.linecorp.centraldogma.server.credential.CreateCredentialRequest;
import com.linecorp.centraldogma.server.credential.Credential;
import com.linecorp.centraldogma.server.internal.api.AbstractService;
import com.linecorp.centraldogma.server.internal.api.auth.RequiresProjectRole;
import com.linecorp.centraldogma.server.internal.api.auth.RequiresRepositoryRole;
import com.linecorp.centraldogma.server.internal.storage.project.ProjectApiManager;
import com.linecorp.centraldogma.server.metadata.User;
import com.linecorp.centraldogma.server.storage.repository.MetaRepository;
import com.linecorp.centraldogma.server.storage.repository.Repository;
import java.util.List;
import java.util.concurrent.CompletableFuture;

@ProducesJson
public class CredentialServiceV1
extends AbstractService {
    private final ProjectApiManager projectApiManager;

    public CredentialServiceV1(ProjectApiManager projectApiManager, CommandExecutor executor) {
        super(executor);
        this.projectApiManager = projectApiManager;
    }

    @RequiresProjectRole(value=ProjectRole.MEMBER)
    @Get(value="/projects/{projectName}/credentials")
    public CompletableFuture<List<Credential>> listCredentials(User loginUser, @Param String projectName) {
        CompletableFuture<List<Credential>> future = this.metaRepo(projectName, loginUser).projectCredentials();
        return CredentialServiceV1.maybeMaskSecret(loginUser, future);
    }

    private static CompletableFuture<List<Credential>> maybeMaskSecret(User loginUser, CompletableFuture<List<Credential>> future) {
        if (loginUser.isSystemAdmin()) {
            return future;
        }
        return future.thenApply(credentials -> (List)credentials.stream().map(Credential::withoutSecret).collect(ImmutableList.toImmutableList()));
    }

    @RequiresProjectRole(value=ProjectRole.MEMBER)
    @Get(value="/projects/{projectName}/credentials/{id}")
    public CompletableFuture<Credential> getCredential(User loginUser, @Param String projectName, @Param String id) {
        CompletableFuture<Credential> future = this.metaRepo(projectName, loginUser).credential(CredentialUtil.credentialName((String)projectName, (String)id));
        if (loginUser.isSystemAdmin()) {
            return future;
        }
        return future.thenApply(Credential::withoutSecret);
    }

    @ConsumesJson
    @StatusCode(value=201)
    @Post(value="/projects/{projectName}/credentials")
    @RequiresProjectRole(value=ProjectRole.OWNER)
    public CompletableFuture<PushResultDto> createCredential(@Param String projectName, CreateCredentialRequest request, Author author, User user) {
        String credentialId = request.credentialId();
        String credentialName = CredentialUtil.credentialName((String)projectName, (String)credentialId);
        Credential credential = request.credential().withName(credentialName);
        return this.createOrUpdate(projectName, credential, author, user, false);
    }

    @ConsumesJson
    @Put(value="/projects/{projectName}/credentials/{id}")
    @RequiresProjectRole(value=ProjectRole.OWNER)
    public CompletableFuture<PushResultDto> updateCredential(@Param String projectName, @Param String id, Credential credential, Author author, User user) {
        Preconditions.checkArgument((boolean)id.equals(credential.id()), (String)"The credential ID (%s) can't be updated", (Object)id);
        return this.createOrUpdate(projectName, credential, author, user, true);
    }

    @Delete(value="/projects/{projectName}/credentials/{id}")
    @RequiresProjectRole(value=ProjectRole.OWNER)
    public CompletableFuture<Void> deleteCredential(@Param String projectName, @Param String id, Author author, User user) {
        MetaRepository metaRepository = this.metaRepo(projectName, user);
        return this.deleteCredential(projectName, author, metaRepository, CredentialUtil.credentialName((String)projectName, (String)id));
    }

    private CompletableFuture<Void> deleteCredential(String projectName, Author author, MetaRepository metaRepository, String credentialName) {
        return metaRepository.credential(credentialName).thenCompose(credential -> {
            Command<CommitResult> command = Command.push(author, projectName, metaRepository.name(), Revision.HEAD, "Delete credential: " + credentialName, "", Markup.PLAINTEXT, Change.ofRemoval((String)CredentialUtil.credentialFile((String)credentialName)));
            return this.executor().execute(command).thenApply(result -> null);
        });
    }

    private CompletableFuture<PushResultDto> createOrUpdate(String projectName, Credential credential, Author author, User user, boolean update) {
        CredentialUtil.validateProjectCredentialName((String)projectName, (String)credential.name());
        CompletableFuture<Command<CommitResult>> future = this.metaRepo(projectName, user).createCredentialPushCommand(credential, author, update);
        return this.push(future);
    }

    private CompletableFuture<PushResultDto> push(CompletableFuture<Command<CommitResult>> future) {
        return future.thenCompose(command -> this.executor().execute(command).thenApply(result -> new PushResultDto(result.revision(), command.timestamp())));
    }

    private MetaRepository metaRepo(String projectName, User user) {
        return this.projectApiManager.getProject(projectName, user).metaRepo();
    }

    @RequiresRepositoryRole(value=RepositoryRole.ADMIN)
    @Get(value="/projects/{projectName}/repos/{repoName}/credentials")
    public CompletableFuture<List<Credential>> listRepoCredentials(User loginUser, @Param String projectName, Repository repository) {
        CompletableFuture<List<Credential>> future = this.metaRepo(projectName, loginUser).repoCredentials(repository.name());
        return CredentialServiceV1.maybeMaskSecret(loginUser, future);
    }

    @RequiresRepositoryRole(value=RepositoryRole.ADMIN)
    @Get(value="/projects/{projectName}/repos/{repoName}/credentials/{id}")
    public CompletableFuture<Credential> getRepoCredential(User loginUser, @Param String projectName, Repository repository, @Param String id) {
        CompletableFuture<Credential> future = this.metaRepo(projectName, loginUser).credential(CredentialUtil.credentialName((String)projectName, (String)repository.name(), (String)id));
        if (loginUser.isSystemAdmin()) {
            return future;
        }
        return future.thenApply(Credential::withoutSecret);
    }

    @ConsumesJson
    @StatusCode(value=201)
    @RequiresRepositoryRole(value=RepositoryRole.ADMIN)
    @Post(value="/projects/{projectName}/repos/{repoName}/credentials")
    public CompletableFuture<PushResultDto> createRepoCredential(@Param String projectName, Repository repository, CreateCredentialRequest request, Author author, User user) {
        String credentialId = request.credentialId();
        String repoName = repository.name();
        String credentialName = CredentialUtil.credentialName((String)projectName, (String)repoName, (String)credentialId);
        Credential credential = request.credential().withName(credentialName);
        return this.createOrUpdateRepo(projectName, repoName, credential, author, user, false);
    }

    @ConsumesJson
    @RequiresRepositoryRole(value=RepositoryRole.ADMIN)
    @Put(value="/projects/{projectName}/repos/{repoName}/credentials/{id}")
    public CompletableFuture<PushResultDto> updateRepoCredential(@Param String projectName, Repository repository, @Param String id, Credential credential, Author author, User user) {
        Preconditions.checkArgument((boolean)id.equals(credential.id()), (String)"The credential ID (%s) can't be updated", (Object)id);
        return this.createOrUpdateRepo(projectName, repository.name(), credential, author, user, true);
    }

    private CompletableFuture<PushResultDto> createOrUpdateRepo(String projectName, String repoName, Credential credential, Author author, User user, boolean update) {
        CredentialUtil.validateRepoCredentialName((String)projectName, (String)repoName, (String)credential.name());
        CompletableFuture<Command<CommitResult>> future = this.metaRepo(projectName, user).createCredentialPushCommand(repoName, credential, author, update);
        return this.push(future);
    }

    @RequiresRepositoryRole(value=RepositoryRole.ADMIN)
    @Delete(value="/projects/{projectName}/repos/{repoName}/credentials/{id}")
    public CompletableFuture<Void> deleteRepoCredential(@Param String projectName, Repository repository, @Param String id, Author author, User user) {
        MetaRepository metaRepository = this.metaRepo(projectName, user);
        return this.deleteCredential(projectName, author, metaRepository, CredentialUtil.credentialName((String)projectName, (String)repository.name(), (String)id));
    }
}

