/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.admin.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpMethod;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.common.ResponseHeaders;
import com.linecorp.armeria.common.ResponseHeadersBuilder;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.annotation.ResponseConverterFunction;
import com.linecorp.centraldogma.internal.Jackson;
import com.linecorp.centraldogma.server.internal.api.HttpApiUtil;
import javax.annotation.Nullable;

public class RestfulJsonResponseConverter
implements ResponseConverterFunction {
    private static final HttpData EMPTY_RESULT = HttpData.ofUtf8((String)"{}");

    public HttpResponse convertResponse(ServiceRequestContext ctx, ResponseHeaders headers, @Nullable Object resObj, HttpHeaders trailingHeaders) throws Exception {
        try {
            HttpRequest request = RequestContext.current().request();
            HttpData httpData = resObj != null && resObj.getClass() == Object.class ? EMPTY_RESULT : HttpData.wrap((byte[])Jackson.writeValueAsBytes((Object)resObj));
            ResponseHeadersBuilder builder = headers.toBuilder();
            if (HttpMethod.POST == request.method()) {
                builder.status(HttpStatus.CREATED);
            }
            if (builder.contentType() == null) {
                builder.contentType(MediaType.JSON_UTF_8);
            }
            return HttpResponse.of((ResponseHeaders)builder.build(), (HttpData)httpData, (HttpHeaders)trailingHeaders);
        }
        catch (JsonProcessingException e) {
            return HttpApiUtil.newResponse(ctx, HttpStatus.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
    }
}

