/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.admin.service;

import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.ResponseHeaders;
import com.linecorp.armeria.common.ResponseHeadersBuilder;
import com.linecorp.armeria.common.ServerCacheControl;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.annotation.Get;
import com.linecorp.armeria.server.annotation.ResponseConverter;
import com.linecorp.centraldogma.internal.Jackson;
import com.linecorp.centraldogma.server.auth.AuthProvider;
import com.linecorp.centraldogma.server.auth.SessionManager;
import com.linecorp.centraldogma.server.command.CommandExecutor;
import com.linecorp.centraldogma.server.internal.admin.auth.AuthUtil;
import com.linecorp.centraldogma.server.internal.admin.auth.SessionCookieHandler;
import com.linecorp.centraldogma.server.internal.admin.auth.SessionUtil;
import com.linecorp.centraldogma.server.internal.admin.util.RestfulJsonResponseConverter;
import com.linecorp.centraldogma.server.internal.api.AbstractService;
import com.linecorp.centraldogma.server.metadata.User;
import com.linecorp.centraldogma.server.storage.encryption.EncryptionStorageManager;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;

@ResponseConverter(value=RestfulJsonResponseConverter.class)
public class UserService
extends AbstractService {
    @Nullable
    private final SessionManager sessionManager;
    @Nullable
    private final SessionCookieHandler sessionCookieHandler;

    public UserService(@Nullable SessionManager sessionManager, boolean tlsEnabled, CommandExecutor executor, @Nullable AuthProvider authProvider, EncryptionStorageManager encryptionStorageManager) {
        super(executor);
        this.sessionManager = sessionManager;
        if (authProvider != null) {
            assert (sessionManager != null);
            this.sessionCookieHandler = new SessionCookieHandler(authProvider.parameters().sessionPropagatorWritableChecker(), tlsEnabled, encryptionStorageManager);
        } else {
            this.sessionCookieHandler = null;
        }
    }

    @Get(value="/users/me")
    public HttpResponse usersMe(ServiceRequestContext ctx) throws Exception {
        User user = AuthUtil.currentUser();
        HttpData body = HttpData.wrap((byte[])Jackson.writeValueAsBytes((Object)user));
        if (this.sessionManager != null) {
            assert (this.sessionCookieHandler != null);
            return HttpResponse.of((CompletableFuture)this.sessionCookieHandler.getSessionInfo(ctx).thenApply(sessionInfo -> {
                if (sessionInfo == null) {
                    return HttpResponse.of((HttpStatus)HttpStatus.OK, (MediaType)MediaType.JSON_UTF_8, (HttpData)body);
                }
                String sessionId = sessionInfo.sessionId();
                if (sessionId == null) {
                    String username = sessionInfo.username();
                    String csrfTokenFromSignedJwt = sessionInfo.csrfTokenFromSignedJwt();
                    assert (username != null);
                    assert (csrfTokenFromSignedJwt != null);
                    return UserService.httpResponse(csrfTokenFromSignedJwt, body);
                }
                return HttpResponse.of((CompletableFuture)this.sessionManager.get(sessionId).thenApply(session -> {
                    if (session == null) {
                        return HttpResponse.of((HttpStatus)HttpStatus.OK, (MediaType)MediaType.JSON_UTF_8, (HttpData)body);
                    }
                    String csrfToken = session.csrfToken();
                    return UserService.httpResponse(csrfToken, body);
                }));
            }));
        }
        return HttpResponse.of((HttpStatus)HttpStatus.OK, (MediaType)MediaType.JSON_UTF_8, (HttpData)body);
    }

    private static HttpResponse httpResponse(@Nullable String csrfToken, HttpData body) {
        ResponseHeadersBuilder builder = ResponseHeaders.builder((HttpStatus)HttpStatus.OK).contentType(MediaType.JSON_UTF_8).set((CharSequence)HttpHeaderNames.CACHE_CONTROL, ServerCacheControl.DISABLED.asHeaderValue());
        if (csrfToken != null) {
            builder.set((CharSequence)SessionUtil.X_CSRF_TOKEN, csrfToken);
        }
        return HttpResponse.of((ResponseHeaders)builder.build(), (HttpData)body);
    }
}

