/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.admin.auth;

import com.linecorp.armeria.common.Cookie;
import com.linecorp.armeria.common.CookieBuilder;
import com.linecorp.armeria.common.Cookies;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.centraldogma.internal.shaded.guava.base.Strings;
import com.linecorp.centraldogma.internal.shaded.guava.hash.Hashing;
import com.linecorp.centraldogma.server.auth.Session;
import com.linecorp.centraldogma.server.auth.SessionKey;
import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JOSEObjectType;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWEDecrypter;
import com.nimbusds.jose.JWEEncrypter;
import com.nimbusds.jose.JWEHeader;
import com.nimbusds.jose.JWEObject;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.Payload;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.jwt.proc.BadJWTException;
import com.nimbusds.jwt.proc.DefaultJWTClaimsVerifier;
import io.netty.util.AsciiString;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Date;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SessionUtil {
    private static final Logger logger = LoggerFactory.getLogger(SessionUtil.class);
    public static final AsciiString X_CSRF_TOKEN = HttpHeaderNames.of((CharSequence)"X-CSRF-Token");
    public static final long DEFAULT_READ_ONLY_MODE_SESSION_TIMEOUT_MILLIS = Duration.ofMinutes(30L).toMillis();

    public static boolean constantTimeEquals(@com.linecorp.armeria.common.annotation.Nullable String a, @com.linecorp.armeria.common.annotation.Nullable String b) {
        if (a == null || b == null) {
            return false;
        }
        if (a.length() != b.length()) {
            return false;
        }
        int result = 0;
        for (int i = 0; i < a.length(); ++i) {
            result |= a.charAt(i) ^ b.charAt(i);
        }
        return result == 0;
    }

    public static Cookie createSessionCookie(String sessionCookieName, String sessionCookieValue, boolean tlsEnabled, long cookieMaxAgeSecond) {
        CookieBuilder cookieBuilder = Cookie.secureBuilder((String)sessionCookieName, (String)sessionCookieValue).maxAge(cookieMaxAgeSecond).path("/");
        if (!tlsEnabled) {
            cookieBuilder.secure(false);
        }
        return cookieBuilder.build();
    }

    public static String sessionCookieName(boolean tlsEnabled, boolean encryptSessionCookie) {
        String prefix = tlsEnabled ? "__Host-Http-" : "";
        return encryptSessionCookie ? prefix + "session-jwt" : prefix + "session-id";
    }

    public static int getSessionKeyVersion(ServiceRequestContext ctx, String cookieValue) {
        String keyVersion;
        try {
            JWEObject jweObject = JWEObject.parse((String)cookieValue);
            JWEHeader header = jweObject.getHeader();
            keyVersion = header.getKeyID();
        }
        catch (Exception e) {
            logger.trace("Failed to parse the session cookie for getting key ID. cookieValue={}, ctx={}", new Object[]{cookieValue, ctx, e});
            return -1;
        }
        try {
            return Integer.parseInt(keyVersion);
        }
        catch (Exception e) {
            logger.trace("Failed to parse the key ID to integer. keyID={}, ctx={}", new Object[]{keyVersion, ctx, e});
            return -1;
        }
    }

    @com.linecorp.armeria.common.annotation.Nullable
    public static SignedJWT getSignedJwtFromEncryptedCookie(ServiceRequestContext ctx, String sessionCookieName, JWEDecrypter decrypter) {
        Cookie sessionCookie = SessionUtil.findSessionCookie(ctx, sessionCookieName);
        if (sessionCookie == null) {
            return null;
        }
        String cookieValue = sessionCookie.value();
        return SessionUtil.decryptAndGetSignedJwt(ctx, decrypter, cookieValue);
    }

    static SignedJWT decryptAndGetSignedJwt(ServiceRequestContext ctx, JWEDecrypter decrypter, String cookieValue) {
        JWEObject jweObject;
        try {
            jweObject = JWEObject.parse((String)cookieValue);
            jweObject.decrypt(decrypter);
        }
        catch (Exception e) {
            logger.trace("Failed to parse the session cookie. ctx={}", (Object)ctx, (Object)e);
            return null;
        }
        Payload payload = jweObject.getPayload();
        String jwsString = payload.toString();
        try {
            return SignedJWT.parse((String)jwsString);
        }
        catch (Exception e) {
            logger.trace("Failed to parse the inner JWS. ctx={}", (Object)ctx, (Object)e);
            return null;
        }
    }

    @com.linecorp.armeria.common.annotation.Nullable
    static JWTClaimsSet getJwtClaimsSetFromSignedJwt(ServiceRequestContext ctx, SignedJWT signedJWT, SessionKey sessionKey, DefaultJWTClaimsVerifier<?> verifier) {
        JWTClaimsSet jwtClaimsSet;
        try {
            if (!signedJWT.verify((JWSVerifier)sessionKey.verifier())) {
                logger.trace("Invalid JWS signature. ctx={}", (Object)ctx);
                return null;
            }
        }
        catch (JOSEException e) {
            logger.trace("Failed to verify the JWS signature. ctx={}", (Object)ctx, (Object)e);
            return null;
        }
        try {
            jwtClaimsSet = signedJWT.getJWTClaimsSet();
        }
        catch (Exception e) {
            logger.trace("Failed to parse the inner JWS. ctx={}", (Object)ctx, (Object)e);
            return null;
        }
        try {
            verifier.verify(jwtClaimsSet, null);
            return jwtClaimsSet;
        }
        catch (BadJWTException e) {
            logger.trace("Invalid claim set in the inner JWS. ctx={}", (Object)ctx, (Object)e);
            return null;
        }
    }

    static String csrfTokenFromSignedJwt(SignedJWT signedJwt) {
        return Hashing.sha256().hashString((CharSequence)signedJwt.getSignature().toString(), StandardCharsets.UTF_8).toString();
    }

    public static boolean validateCsrfToken(ServiceRequestContext ctx, HttpRequest req, @Nullable String expectedCsrfToken) {
        if (SessionUtil.isSafeMethod(req)) {
            return true;
        }
        String csrfToken = req.headers().get((CharSequence)X_CSRF_TOKEN, "");
        if (!SessionUtil.constantTimeEquals(csrfToken, expectedCsrfToken)) {
            logger.trace("CSRF token mismatch: tokenPresent={}, ctx={}", (Object)(!Strings.isNullOrEmpty((String)csrfToken) ? 1 : 0), (Object)ctx);
            return false;
        }
        return true;
    }

    private static boolean isSafeMethod(HttpRequest req) {
        switch (req.method()) {
            case GET: 
            case HEAD: 
            case OPTIONS: {
                return true;
            }
        }
        return false;
    }

    @com.linecorp.armeria.common.annotation.Nullable
    public static String getSessionIdFromCookie(ServiceRequestContext ctx, String sessionCookieName) {
        Cookie sessionCookie = SessionUtil.findSessionCookie(ctx, sessionCookieName);
        if (sessionCookie == null) {
            return null;
        }
        return sessionCookie.value();
    }

    @com.linecorp.armeria.common.annotation.Nullable
    public static Cookie findSessionCookie(ServiceRequestContext ctx, String sessionCookieName) {
        Cookies cookies = ctx.request().headers().cookies();
        if (cookies.isEmpty()) {
            logger.trace("Cookie header is missing. ctx={}", (Object)ctx);
            return null;
        }
        Cookie sessionCookie = SessionUtil.findSessionCookie(cookies, sessionCookieName);
        if (sessionCookie == null) {
            logger.trace("Session cookie is missing. ctx={}", (Object)ctx);
            return null;
        }
        return sessionCookie;
    }

    @com.linecorp.armeria.common.annotation.Nullable
    private static Cookie findSessionCookie(Cookies cookies, String sessionCookieName) {
        for (Cookie cookie : cookies) {
            if (!sessionCookieName.equals(cookie.name())) continue;
            return cookie;
        }
        return null;
    }

    public static String createSessionJwe(Session session, String sessionKeyVersion, JWSSigner signer, JWEEncrypter encrypter) {
        return SessionUtil.createJwe(SessionUtil.createSignedJwt(session, sessionKeyVersion, signer).serialize(), sessionKeyVersion, encrypter);
    }

    public static SignedJWT createSignedJwt(Session session, String sessionKeyVersion, JWSSigner signer) {
        JWTClaimsSet claimsSet = new JWTClaimsSet.Builder().subject(session.username()).claim("sessionId", (Object)session.id()).issuer("dogma").issueTime(Date.from(session.creationTime())).expirationTime(Date.from(session.expirationTime())).build();
        return SessionUtil.createSignedJwt(sessionKeyVersion, signer, claimsSet);
    }

    private static SignedJWT createSignedJwt(String sessionKeyVersion, JWSSigner signer, JWTClaimsSet claimsSet) {
        JWSHeader jwsHeader = new JWSHeader.Builder(JWSAlgorithm.HS256).type(JOSEObjectType.JWT).keyID(sessionKeyVersion).build();
        SignedJWT signedJWT = new SignedJWT(jwsHeader, claimsSet);
        try {
            signedJWT.sign(signer);
        }
        catch (JOSEException e) {
            throw new IllegalArgumentException("Failed to sign a JWT.", e);
        }
        return signedJWT;
    }

    public static SignedJWT createSignedJwtInReadOnly(String username, String sessionKeyVersion, JWSSigner signer) {
        long now = System.currentTimeMillis();
        JWTClaimsSet claimsSet = new JWTClaimsSet.Builder().subject(username).issuer("dogma").issueTime(new Date(now)).expirationTime(new Date(now + DEFAULT_READ_ONLY_MODE_SESSION_TIMEOUT_MILLIS)).build();
        return SessionUtil.createSignedJwt(sessionKeyVersion, signer, claimsSet);
    }

    public static String createJwe(String signedJwt, String sessionKeyVersion, JWEEncrypter encrypter) {
        JWEHeader jweHeader = new JWEHeader.Builder(JWEAlgorithm.DIR, EncryptionMethod.A256GCM).contentType("JWT").keyID(sessionKeyVersion).build();
        Payload payload = new Payload(signedJwt);
        JWEObject jweObject = new JWEObject(jweHeader, payload);
        try {
            jweObject.encrypt(encrypter);
        }
        catch (JOSEException e) {
            throw new IllegalArgumentException("Failed to encrypt a JWT.", e);
        }
        return jweObject.serialize();
    }

    private SessionUtil() {
    }
}

