/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.admin.auth;

import com.linecorp.armeria.common.Cookie;
import com.linecorp.armeria.common.util.UnmodifiableFuture;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.centraldogma.internal.shaded.guava.base.Strings;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableSet;
import com.linecorp.centraldogma.server.auth.SessionKey;
import com.linecorp.centraldogma.server.internal.admin.auth.SessionUtil;
import com.linecorp.centraldogma.server.storage.encryption.EncryptionStorageManager;
import com.nimbusds.jose.proc.SecurityContext;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.jwt.proc.DefaultJWTClaimsVerifier;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;

public final class SessionCookieHandler {
    private final BooleanSupplier sessionPropagatorWritableChecker;
    private final EncryptionStorageManager encryptionStorageManager;
    private final String sessionCookieName;
    @Nullable
    private volatile SessionKey sessionKey;
    @Nullable
    private final DefaultJWTClaimsVerifier<SecurityContext> jwtClaimsVerifier;

    public SessionCookieHandler(BooleanSupplier sessionPropagatorWritableChecker, boolean tlsEnabled, EncryptionStorageManager encryptionStorageManager) {
        this.sessionPropagatorWritableChecker = Objects.requireNonNull(sessionPropagatorWritableChecker, "sessionPropagatorWritableChecker");
        this.encryptionStorageManager = Objects.requireNonNull(encryptionStorageManager, "encryptionStorageManager");
        this.sessionCookieName = SessionUtil.sessionCookieName(tlsEnabled, encryptionStorageManager.encryptSessionCookie());
        if (encryptionStorageManager.encryptSessionCookie()) {
            this.sessionKey = encryptionStorageManager.getCurrentSessionKey().join();
            encryptionStorageManager.addSessionKeyListener(sessionKey -> {
                this.sessionKey = sessionKey;
            });
            this.jwtClaimsVerifier = new DefaultJWTClaimsVerifier(new JWTClaimsSet.Builder().issuer("dogma").build(), (Set)ImmutableSet.of((Object)"exp"));
        } else {
            this.sessionKey = null;
            this.jwtClaimsVerifier = null;
        }
    }

    public CompletableFuture<SessionInfo> getSessionInfo(ServiceRequestContext ctx) {
        if (this.encryptionStorageManager.encryptSessionCookie()) {
            SessionKey sessionKey = this.sessionKey;
            assert (sessionKey != null);
            Cookie sessionCookie = SessionUtil.findSessionCookie(ctx, this.sessionCookieName);
            if (sessionCookie == null) {
                return UnmodifiableFuture.completedFuture(null);
            }
            int sessionKeyVersion = SessionUtil.getSessionKeyVersion(ctx, sessionCookie.value());
            if (sessionKeyVersion <= 0) {
                return UnmodifiableFuture.completedFuture(null);
            }
            if (sessionKeyVersion == sessionKey.version()) {
                return CompletableFuture.completedFuture(this.getSessionInfo(ctx, sessionKey));
            }
            return this.encryptionStorageManager.getSessionKey(sessionKeyVersion).thenApply(fetchedSessionKey -> this.getSessionInfo(ctx, (SessionKey)fetchedSessionKey));
        }
        String sessionId = SessionUtil.getSessionIdFromCookie(ctx, this.sessionCookieName);
        return sessionId != null ? CompletableFuture.completedFuture(new SessionInfo(sessionId, null, null)) : UnmodifiableFuture.completedFuture(null);
    }

    @Nullable
    private SessionInfo getSessionInfo(ServiceRequestContext ctx, SessionKey sessionKey) {
        SignedJWT signedJwt = SessionUtil.getSignedJwtFromEncryptedCookie(ctx, this.sessionCookieName, sessionKey.decrypter());
        if (signedJwt == null) {
            return null;
        }
        assert (this.jwtClaimsVerifier != null);
        JWTClaimsSet jwtClaimsSet = SessionUtil.getJwtClaimsSetFromSignedJwt(ctx, signedJwt, sessionKey, this.jwtClaimsVerifier);
        if (jwtClaimsSet == null) {
            return null;
        }
        Object objectSessionId = jwtClaimsSet.getClaim("sessionId");
        if (objectSessionId instanceof String) {
            return new SessionInfo((String)objectSessionId, null, null);
        }
        if (this.sessionPropagatorWritableChecker.getAsBoolean()) {
            return null;
        }
        String subject = jwtClaimsSet.getSubject();
        if (Strings.isNullOrEmpty((String)subject)) {
            return null;
        }
        String csrfTokenFromSignedJwt = SessionUtil.csrfTokenFromSignedJwt(signedJwt);
        return new SessionInfo(null, subject, csrfTokenFromSignedJwt);
    }

    public static final class SessionInfo {
        @Nullable
        private final String sessionId;
        @Nullable
        private final String username;
        @Nullable
        private final String csrfTokenFromSignedJwt;

        SessionInfo(@Nullable String sessionId, @Nullable String username, @Nullable String csrfTokenFromSignedJwt) {
            this.csrfTokenFromSignedJwt = csrfTokenFromSignedJwt;
            assert (sessionId != null || username != null && csrfTokenFromSignedJwt != null);
            this.sessionId = sessionId;
            this.username = username;
        }

        @Nullable
        public String sessionId() {
            return this.sessionId;
        }

        @Nullable
        public String username() {
            return this.username;
        }

        @Nullable
        public String csrfTokenFromSignedJwt() {
            return this.csrfTokenFromSignedJwt;
        }
    }
}

