/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.admin.auth;

import com.linecorp.centraldogma.internal.Util;
import com.linecorp.centraldogma.server.auth.Session;
import com.linecorp.centraldogma.server.auth.SessionManager;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

public class ForwardingSessionManager
implements SessionManager {
    private final SessionManager delegate;

    protected ForwardingSessionManager(SessionManager delegate) {
        this.delegate = Objects.requireNonNull(delegate, "delegate");
    }

    protected final <T extends SessionManager> T delegate() {
        return (T)((SessionManager)Util.unsafeCast((Object)this.delegate));
    }

    @Override
    public String generateSessionId() {
        return this.delegate().generateSessionId();
    }

    @Override
    public CompletableFuture<Boolean> exists(String sessionId) {
        return this.delegate().exists(sessionId);
    }

    @Override
    public CompletableFuture<Session> get(String sessionId) {
        return this.delegate().get(sessionId);
    }

    @Override
    public CompletableFuture<Void> create(Session session) {
        return this.delegate().create(session);
    }

    @Override
    public CompletableFuture<Void> update(Session session) {
        return this.delegate().update(session);
    }

    @Override
    public CompletableFuture<Void> delete(String sessionId) {
        return this.delegate().delete(sessionId);
    }

    @Override
    public void close() throws Exception {
        this.delegate().close();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + String.valueOf(this.delegate()) + ")";
    }
}

