/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.command;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.linecorp.centraldogma.common.Author;
import com.linecorp.centraldogma.internal.shaded.guava.base.MoreObjects;
import com.linecorp.centraldogma.internal.shaded.guava.base.Preconditions;
import com.linecorp.centraldogma.server.command.CommandType;
import com.linecorp.centraldogma.server.command.ProjectCommand;
import com.linecorp.centraldogma.server.storage.encryption.WrappedDekDetails;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public final class CreateRepositoryCommand
extends ProjectCommand<Void> {
    private final String repositoryName;
    @Nullable
    private final WrappedDekDetails wdekDetails;

    @JsonCreator
    CreateRepositoryCommand(@JsonProperty(value="timestamp") @Nullable Long timestamp, @JsonProperty(value="author") @Nullable Author author, @JsonProperty(value="projectName") String projectName, @JsonProperty(value="repositoryName") String repositoryName, @JsonProperty(value="wdekDetails") @Nullable WrappedDekDetails wdekDetails) {
        super(CommandType.CREATE_REPOSITORY, timestamp, author, projectName);
        this.repositoryName = Objects.requireNonNull(repositoryName, "repositoryName");
        this.wdekDetails = wdekDetails;
        if (wdekDetails != null) {
            Preconditions.checkArgument((wdekDetails.projectName().equals(projectName) && wdekDetails.repoName().equals(repositoryName) ? 1 : 0) != 0, (String)"projectName: %s and repositoryName: %s, (expected projectName: %s and repositoryName: %s in wdekDetails)", (Object)projectName, (Object)repositoryName, (Object)wdekDetails.projectName(), (Object)wdekDetails.repoName());
        }
    }

    @JsonProperty
    public String repositoryName() {
        return this.repositoryName;
    }

    @JsonProperty
    @Nullable
    public WrappedDekDetails wdekDetails() {
        return this.wdekDetails;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CreateRepositoryCommand)) {
            return false;
        }
        CreateRepositoryCommand that = (CreateRepositoryCommand)obj;
        return super.equals(obj) && this.repositoryName.equals(that.repositoryName) && Objects.equals(this.wdekDetails, that.wdekDetails);
    }

    @Override
    public int hashCode() {
        return (this.repositoryName.hashCode() * 31 + Objects.hashCode(this.wdekDetails)) * 31 + super.hashCode();
    }

    @Override
    MoreObjects.ToStringHelper toStringHelper() {
        return super.toStringHelper().omitNullValues().add("repositoryName", (Object)this.repositoryName).add("wdekDetails", (Object)this.wdekDetails);
    }
}

