/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.auth;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.linecorp.centraldogma.internal.shaded.guava.base.MoreObjects;
import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public final class Session {
    private final String id;
    @Nullable
    private final String csrfToken;
    private final String username;
    private final Instant creationTime;
    private final Instant expirationTime;

    public Session(String id, String csrfToken, String username, Duration sessionValidDuration) {
        this.id = Objects.requireNonNull(id, "id");
        this.csrfToken = Objects.requireNonNull(csrfToken, "csrfToken");
        this.username = Objects.requireNonNull(username, "username");
        this.creationTime = Instant.now();
        this.expirationTime = this.creationTime.plus(Objects.requireNonNull(sessionValidDuration, "sessionValidDuration"));
    }

    @JsonCreator
    public Session(@JsonProperty(value="id") String id, @JsonProperty(value="csrfToken") @Nullable String csrfToken, @JsonProperty(value="username") String username, @JsonProperty(value="creationTime") Instant creationTime, @JsonProperty(value="expirationTime") Instant expirationTime, @JsonProperty(value="rawSession") @Nullable Serializable unused) {
        this.id = Objects.requireNonNull(id, "id");
        this.csrfToken = csrfToken;
        this.username = Objects.requireNonNull(username, "username");
        this.creationTime = Objects.requireNonNull(creationTime, "creationTime");
        this.expirationTime = Objects.requireNonNull(expirationTime, "expirationTime");
    }

    @JsonProperty
    public String id() {
        return this.id;
    }

    @JsonProperty
    @Nullable
    public String csrfToken() {
        return this.csrfToken;
    }

    @JsonProperty
    public String username() {
        return this.username;
    }

    @JsonProperty
    public Instant creationTime() {
        return this.creationTime;
    }

    @JsonProperty
    public Instant expirationTime() {
        return this.expirationTime;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.csrfToken, this.username, this.creationTime, this.expirationTime);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Session)) {
            return false;
        }
        Session that = (Session)obj;
        return this.id.equals(that.id) && Objects.equals(this.csrfToken, that.csrfToken) && this.username.equals(that.username) && this.creationTime.equals(that.creationTime) && this.expirationTime.equals(that.expirationTime);
    }

    public String toString() {
        MoreObjects.ToStringHelper toStringHelper = MoreObjects.toStringHelper((Object)this).add("id", (Object)"****").add("username", (Object)this.username).add("creationTime", (Object)this.creationTime).add("expirationTime", (Object)this.expirationTime);
        if (this.csrfToken != null) {
            toStringHelper.add("csrfToken", (Object)"****");
        }
        return toStringHelper.toString();
    }
}

