/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.auth;

import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.server.HttpService;
import com.linecorp.centraldogma.server.auth.AllowedUrisConfig;
import java.util.Objects;

final class AuthProviderUtil {
    static HttpService loginOrLogoutService(AllowedUrisConfig allowedUrisConfig, String builtinWebPath) {
        Objects.requireNonNull(allowedUrisConfig, "allowedUrisConfig");
        return (ctx, req) -> {
            String returnTo = ctx.queryParam("return_to");
            if (allowedUrisConfig.isAllowedRedirectUri(returnTo)) {
                return HttpResponse.ofRedirect((HttpStatus)HttpStatus.MOVED_PERMANENTLY, (String)(returnTo + builtinWebPath));
            }
            return HttpResponse.ofRedirect((HttpStatus)HttpStatus.MOVED_PERMANENTLY, (String)builtinWebPath);
        };
    }

    private AuthProviderUtil() {
    }
}

