/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.auth;

import com.linecorp.armeria.server.HttpService;
import com.linecorp.armeria.server.HttpServiceWithRoutes;
import com.linecorp.armeria.server.Route;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableSet;
import com.linecorp.centraldogma.server.auth.AllowedUrisConfig;
import com.linecorp.centraldogma.server.auth.AuthProviderParameters;
import com.linecorp.centraldogma.server.auth.AuthProviderUtil;
import java.util.Set;
import javax.annotation.Nullable;

@FunctionalInterface
public interface AuthProvider {
    public static final String LOGIN_PATH = "/link/auth/login";
    public static final String LOGOUT_PATH = "/link/auth/logout";
    public static final String BUILTIN_WEB_BASE_PATH = "/web/auth";
    public static final String BUILTIN_WEB_LOGIN_PATH = "/web/auth/login";
    public static final String BUILTIN_WEB_LOGOUT_PATH = "/web/auth/logout";
    public static final Set<Route> LOGIN_API_ROUTES = ImmutableSet.of((Object)Route.builder().exact("/api/v0/authenticate").build(), (Object)Route.builder().exact("/api/v1/login").build());
    public static final Set<Route> LOGOUT_API_ROUTES = ImmutableSet.of((Object)Route.builder().exact("/api/v0/logout").build(), (Object)Route.builder().exact("/api/v1/logout").build());

    default public HttpService webLoginService(AllowedUrisConfig allowedUrisConfig) {
        return AuthProviderUtil.loginOrLogoutService(allowedUrisConfig, BUILTIN_WEB_LOGIN_PATH);
    }

    default public HttpService webLogoutService(AllowedUrisConfig allowedUrisConfig) {
        return AuthProviderUtil.loginOrLogoutService(allowedUrisConfig, BUILTIN_WEB_LOGOUT_PATH);
    }

    @Nullable
    default public HttpService loginApiService() {
        return null;
    }

    @Nullable
    default public HttpService logoutApiService() {
        return null;
    }

    default public Iterable<HttpServiceWithRoutes> moreServices() {
        return ImmutableList.of();
    }

    public AuthProviderParameters parameters();
}

