/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.auth;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.linecorp.centraldogma.internal.Jackson;
import com.linecorp.centraldogma.internal.shaded.guava.base.Ascii;
import com.linecorp.centraldogma.internal.shaded.guava.base.MoreObjects;
import com.linecorp.centraldogma.internal.shaded.guava.base.Preconditions;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableSet;
import com.linecorp.centraldogma.server.auth.AuthProviderFactory;
import com.linecorp.centraldogma.server.internal.storage.repository.RepositoryCache;
import java.text.ParseException;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.quartz.CronExpression;

public final class AuthConfig {
    public static final long DEFAULT_SESSION_TIMEOUT_MILLIS = 28800000L;
    public static final String DEFAULT_SESSION_CACHE_SPEC = "maximumSize=8192,expireAfterWrite=28800s";
    public static final String DEFAULT_SESSION_VALIDATION_SCHEDULE = "0 30 */4 ? * *";
    private final AuthProviderFactory factory;
    private final Set<String> systemAdministrators;
    private final boolean caseSensitiveLoginNames;
    private final String sessionCacheSpec;
    private final long sessionTimeoutMillis;
    private final String sessionValidationSchedule;
    @Nullable
    private final Object properties;

    @JsonCreator
    public AuthConfig(@JsonProperty(value="factoryClassName") String factoryClassName, @JsonProperty(value="systemAdministrators") @Nullable Set<String> systemAdministrators, @JsonProperty(value="caseSensitiveLoginNames") @Nullable Boolean caseSensitiveLoginNames, @JsonProperty(value="sessionCacheSpec") @Nullable String sessionCacheSpec, @JsonProperty(value="sessionTimeoutMillis") @Nullable Long sessionTimeoutMillis, @JsonProperty(value="sessionValidationSchedule") @Nullable String sessionValidationSchedule, @JsonProperty(value="properties") @Nullable JsonNode properties) throws Exception {
        this((AuthProviderFactory)AuthConfig.class.getClassLoader().loadClass(Objects.requireNonNull(factoryClassName, "factoryClassName")).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]), (Set<String>)(systemAdministrators != null ? ImmutableSet.copyOf(systemAdministrators) : ImmutableSet.of()), (boolean)((Boolean)MoreObjects.firstNonNull((Object)caseSensitiveLoginNames, (Object)false)), (String)MoreObjects.firstNonNull((Object)sessionCacheSpec, (Object)DEFAULT_SESSION_CACHE_SPEC), (long)((Long)MoreObjects.firstNonNull((Object)sessionTimeoutMillis, (Object)28800000L)), (String)MoreObjects.firstNonNull((Object)sessionValidationSchedule, (Object)DEFAULT_SESSION_VALIDATION_SCHEDULE), (Object)properties);
    }

    public AuthConfig(AuthProviderFactory factory, Set<String> systemAdministrators, boolean caseSensitiveLoginNames, String sessionCacheSpec, long sessionTimeoutMillis, String sessionValidationSchedule, @Nullable Object properties) {
        this.factory = Objects.requireNonNull(factory, "factory");
        this.systemAdministrators = Objects.requireNonNull(systemAdministrators, "systemAdministrators");
        this.caseSensitiveLoginNames = caseSensitiveLoginNames;
        this.sessionCacheSpec = RepositoryCache.validateCacheSpec(Objects.requireNonNull(sessionCacheSpec, "sessionCacheSpec"));
        Preconditions.checkArgument((sessionTimeoutMillis > 0L ? 1 : 0) != 0, (String)"sessionTimeoutMillis: %s (expected: > 0)", (long)sessionTimeoutMillis);
        this.sessionTimeoutMillis = sessionTimeoutMillis;
        this.sessionValidationSchedule = AuthConfig.validateSchedule(Objects.requireNonNull(sessionValidationSchedule, "sessionValidationSchedule"));
        this.properties = properties;
    }

    public AuthProviderFactory factory() {
        return this.factory;
    }

    @JsonProperty
    public String factoryClassName() {
        return this.factory.getClass().getName();
    }

    @JsonProperty
    public Set<String> systemAdministrators() {
        return this.systemAdministrators;
    }

    @JsonProperty
    public boolean caseSensitiveLoginNames() {
        return this.caseSensitiveLoginNames;
    }

    @JsonProperty
    public String sessionCacheSpec() {
        return this.sessionCacheSpec;
    }

    @JsonProperty
    public long sessionTimeoutMillis() {
        return this.sessionTimeoutMillis;
    }

    @JsonProperty
    public String sessionValidationSchedule() {
        return this.sessionValidationSchedule;
    }

    @Nullable
    @JsonProperty
    public JsonNode properties() {
        if (this.properties instanceof JsonNode) {
            return (JsonNode)this.properties;
        }
        if (this.properties != null) {
            return Jackson.valueToTree((Object)this.properties);
        }
        return null;
    }

    @Nullable
    public <T> T properties(Class<T> clazz) throws JsonProcessingException {
        if (this.properties instanceof JsonNode) {
            return (T)Jackson.treeToValue((TreeNode)((JsonNode)this.properties), clazz);
        }
        if (this.properties == null) {
            return null;
        }
        if (clazz.isAssignableFrom(this.properties.getClass())) {
            return (T)this.properties;
        }
        throw new IllegalArgumentException("properties: " + String.valueOf(this.properties) + " (expected: " + clazz.getName() + ")");
    }

    public Function<String, String> loginNameNormalizer() {
        return this.caseSensitiveLoginNames() ? Function.identity() : Ascii::toLowerCase;
    }

    public String toString() {
        try {
            return Jackson.writeValueAsPrettyString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException(e);
        }
    }

    private static String validateSchedule(String sessionValidationSchedule) {
        try {
            CronExpression.validateExpression((String)sessionValidationSchedule);
            return sessionValidationSchedule;
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Invalid session validation schedule", e);
        }
    }
}

