/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.auth;

import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.centraldogma.server.CorsConfig;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import javax.annotation.Nullable;

public final class AllowedUrisConfig {
    private final List<URI> allowedUris;
    private final boolean allowAllUris;

    public static AllowedUrisConfig of(@Nullable CorsConfig corsConfig) {
        if (corsConfig == null) {
            return new AllowedUrisConfig((List<URI>)ImmutableList.of(), false);
        }
        List<String> allowedOrigins = corsConfig.allowedOrigins();
        if (allowedOrigins.contains("*")) {
            return new AllowedUrisConfig((List<URI>)ImmutableList.of(), true);
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String allowedOrigin : allowedOrigins) {
            try {
                builder.add((Object)new URI(allowedOrigin));
            }
            catch (URISyntaxException uRISyntaxException) {}
        }
        return new AllowedUrisConfig((List<URI>)builder.build(), false);
    }

    public AllowedUrisConfig(List<URI> allowedUris, boolean allowAllUris) {
        this.allowedUris = allowedUris;
        this.allowAllUris = allowAllUris;
    }

    public List<URI> allowedUris() {
        return this.allowedUris;
    }

    public boolean allowAllUris() {
        return this.allowAllUris;
    }

    public boolean isAllowedRedirectUri(@Nullable String returnTo) {
        if (returnTo == null) {
            return false;
        }
        if (this.allowAllUris) {
            return true;
        }
        if (this.allowedUris.isEmpty()) {
            return false;
        }
        try {
            URI toUri = new URI(returnTo);
            String toHost = toUri.getHost();
            if (toHost == null) {
                return false;
            }
            for (URI allowedUri : this.allowedUris) {
                if (!toHost.equalsIgnoreCase(allowedUri.getHost())) continue;
                return true;
            }
        }
        catch (URISyntaxException ignored) {
            return false;
        }
        return false;
    }
}

