/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.linecorp.centraldogma.internal.shaded.guava.base.MoreObjects;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import javax.annotation.Nullable;

public final class EncryptionConfig {
    private static final String ENCRYPTION_MARKER_FILE_NAME = ".encryption-enabled";
    private final boolean enabled;
    private final boolean encryptSessionCookie;
    @Nullable
    private final String kekId;

    @JsonCreator
    public EncryptionConfig(@JsonProperty(value="enabled") @Nullable Boolean enabled, @JsonProperty(value="encryptSessionCookie") @Nullable Boolean encryptSessionCookie, @JsonProperty(value="kekId") @Nullable String kekId) {
        this.enabled = (Boolean)MoreObjects.firstNonNull((Object)enabled, (Object)false);
        boolean bl = this.encryptSessionCookie = this.enabled && (Boolean)MoreObjects.firstNonNull((Object)encryptSessionCookie, (Object)false) != false;
        if (this.enabled) {
            Objects.requireNonNull(kekId, "kekId");
        }
        this.kekId = kekId;
    }

    void validateEncryptionState(File dataDir) {
        Objects.requireNonNull(dataDir, "dataDir");
        Path markerFilePath = dataDir.toPath().resolve(ENCRYPTION_MARKER_FILE_NAME);
        boolean wasEncryptionEnabled = Files.exists(markerFilePath, new LinkOption[0]);
        if (wasEncryptionEnabled && !this.enabled) {
            throw new IllegalStateException("Cannot disable encryption after it has been enabled. Encryption was previously enabled. To proceed, you must keep encryption enabled.");
        }
        if (this.enabled && !wasEncryptionEnabled) {
            try {
                Files.createDirectories(dataDir.toPath(), new FileAttribute[0]);
                String markerContent = "# DO NOT DELETE THIS FILE\n#\n# This file indicates that encryption has been enabled for this Central Dogma server.\n# Once encryption is enabled, it cannot be disabled.\n#\n# Deleting this file may cause the server to malfunction or fail to start.\n";
                Files.write(markerFilePath, "# DO NOT DELETE THIS FILE\n#\n# This file indicates that encryption has been enabled for this Central Dogma server.\n# Once encryption is enabled, it cannot be disabled.\n#\n# Deleting this file may cause the server to malfunction or fail to start.\n".getBytes(), new OpenOption[0]);
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to create encryption marker file: " + String.valueOf(markerFilePath), e);
            }
        }
    }

    @JsonProperty
    public boolean enabled() {
        return this.enabled;
    }

    @JsonProperty
    public boolean encryptSessionCookie() {
        return this.encryptSessionCookie;
    }

    @JsonProperty
    @Nullable
    public String kekId() {
        return this.kekId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("enabled", this.enabled).add("encryptSessionCookie", this.encryptSessionCookie).add("kekId", (Object)this.kekId).toString();
    }
}

