/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.storage.encryption;

import com.linecorp.armeria.common.util.SafeCloseable;
import com.linecorp.centraldogma.internal.shaded.guava.annotations.VisibleForTesting;
import com.linecorp.centraldogma.server.CentralDogmaConfig;
import com.linecorp.centraldogma.server.EncryptionAtRestConfig;
import com.linecorp.centraldogma.server.auth.SessionKey;
import com.linecorp.centraldogma.server.auth.SessionMasterKey;
import com.linecorp.centraldogma.server.storage.encryption.DefaultEncryptionStorageManager;
import com.linecorp.centraldogma.server.storage.encryption.NoopEncryptionStorageManager;
import com.linecorp.centraldogma.server.storage.encryption.SecretKeyWithVersion;
import java.nio.file.Path;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import javax.crypto.SecretKey;

public interface EncryptionStorageManager
extends SafeCloseable {
    public static EncryptionStorageManager of(CentralDogmaConfig cfg) {
        Objects.requireNonNull(cfg, "cfg");
        EncryptionAtRestConfig encryptionAtRestConfig = cfg.encryptionAtRest();
        boolean enabled = encryptionAtRestConfig != null && encryptionAtRestConfig.enabled();
        Path rocksDbPath = cfg.dataDir().toPath().resolve("_rocks");
        if (!enabled) {
            if (rocksDbPath.toFile().exists()) {
                throw new IllegalArgumentException("RocksDB path exists but encryption at rest is disabled.");
            }
            return NoopEncryptionStorageManager.INSTANCE;
        }
        return new DefaultEncryptionStorageManager(rocksDbPath.toString(), encryptionAtRestConfig.encryptSessionCookie());
    }

    @VisibleForTesting
    public static EncryptionStorageManager of(Path path, boolean encryptSessionCookie) {
        Objects.requireNonNull(path, "path");
        return new DefaultEncryptionStorageManager(path.toString(), encryptSessionCookie);
    }

    public boolean enabled();

    public boolean encryptSessionCookie();

    public CompletableFuture<byte[]> generateWdek();

    public CompletableFuture<SessionMasterKey> generateSessionMasterKey();

    public void storeSessionMasterKey(SessionMasterKey var1);

    public CompletableFuture<SessionKey> getCurrentSessionKey();

    public SecretKey getDek(String var1, String var2, int var3);

    public SecretKeyWithVersion getCurrentDek(String var1, String var2);

    public void storeWdek(String var1, String var2, byte[] var3);

    public void removeWdek(String var1, String var2);

    @Nullable
    public byte[] getObject(byte[] var1, byte[] var2);

    @Nullable
    public byte[] getObjectId(byte[] var1, byte[] var2);

    @Nullable
    public byte[] getMetadata(byte[] var1);

    public void putObject(byte[] var1, byte[] var2, byte[] var3, byte[] var4);

    public void putObjectId(byte[] var1, byte[] var2, byte[] var3, byte[] var4, @Nullable byte[] var5);

    public boolean containsMetadata(byte[] var1);

    public void deleteObjectId(byte[] var1, byte[] var2);

    public void deleteRepositoryData(String var1, String var2);

    @Deprecated
    public Map<String, Map<String, byte[]>> getAllData();
}

